/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.javabase;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Debug;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.NativeArithmetic;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.javabase.MethodMapping;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[XXX]", module="[XXX]", source="XXX.c")
public final class Java {
    private Java() {
    }

    public static Object ocamljava_java_make_single_proxy(Class<?>[] il, boolean jlo, Value o, MethodMapping m) {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        CodeRunner cr = OCamlJavaThread.getCodeRunner();
        SingleInvocationHandler ih = new SingleInvocationHandler(o, cr, m, jlo);
        Object res = Proxy.newProxyInstance(cl, il, (InvocationHandler)ih);
        return res;
    }

    private static Object unconvert(Value v, Class<?> type) {
        if (Debug.ENABLED) {
            System.out.println("XXX proxy/unconvert v = " + v);
        }
        if (Debug.ENABLED) {
            System.out.println("XXX proxy/unconvert t = " + type);
        }
        if (Value.class.equals(type)) {
            return v;
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return v != Value.FALSE ? Boolean.TRUE : Boolean.FALSE;
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return (byte)v.asLong();
        }
        if (Character.class.equals(type) || Character.TYPE.equals(type)) {
            return Character.valueOf((char)v.asLong());
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return v.asDouble();
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return Float.valueOf((float)v.asDouble());
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return v.asInt32();
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return v.asInt64();
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return (short)v.asLong();
        }
        return v.asCustom();
    }

    private static Value convert(Object v, Class<?> type) {
        if (Value.class.equals(type)) {
            return (Value)v;
        }
        if (Boolean.class.equals(type)) {
            return (Boolean)v != false ? Value.TRUE : Value.FALSE;
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return Value.createLong(((Byte)v).byteValue());
        }
        if (Character.class.equals(type) || Character.TYPE.equals(type)) {
            return Value.createLong(((Character)v).charValue());
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return Value.createDouble((Double)v);
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return Value.createDouble(((Float)v).floatValue());
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return Value.createInt32((Integer)v);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return Value.createInt64((Long)v);
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return Value.createLong(((Short)v).shortValue());
        }
        return Value.createInstance(v);
    }

    private static final long methodTag(String name) {
        long res = 1L;
        long const223 = 447L;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            long ch = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(name.charAt(i)));
            res = NativeArithmetic.mulint(447L, res);
            res = NativeArithmetic.addint(res, ch << 1 | 1L);
        }
        long accu = res >> 1;
        accu = (accu &= Integer.MAX_VALUE) > 0x3FFFFFFFL ? accu - 0x80000000L : accu;
        return accu << 1 | 1L;
    }

    static class SingleInvocationHandler
    implements InvocationHandler {
        private final Value instance;
        private final CodeRunner runner;
        private final MethodMapping mapping;
        private final Map<Method, Value> cache;
        private final boolean object;

        SingleInvocationHandler(Value i, CodeRunner cr, MethodMapping mm, boolean jlo) {
            assert (i != null) : "null i";
            assert (cr != null) : "null cr";
            this.instance = i;
            this.runner = cr;
            this.mapping = mm;
            this.cache = new HashMap<Method, Value>();
            this.object = jlo;
        }

        private Value getClosure(Method method) {
            Value cached;
            if (Debug.ENABLED) {
                System.out.println("XXX proxy/getClosure" + method);
            }
            if ((cached = this.cache.get(method)) == null) {
                String methName;
                String string = methName = this.mapping == null ? method.getName() : this.mapping.get(method);
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/getClosure methName" + methName);
                }
                Value clos = AbstractCodeRunner.getMethod(this.instance, Java.methodTag(methName));
                this.cache.put(method, clos);
                return clos;
            }
            return cached;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                int len;
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/1");
                }
                boolean inObject = method.getDeclaringClass().equals(Object.class);
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/2");
                }
                if (!this.object && inObject) {
                    if (Debug.ENABLED) {
                        System.out.println("XXX proxy/invoke/3");
                    }
                    return method.invoke((Object)this, args);
                }
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/3B" + method);
                }
                Value clos = this.getClosure(method);
                if (inObject) {
                    if (Debug.ENABLED) {
                        System.out.println("XXX proxy/invoke/4");
                    }
                    int len2 = args == null ? 0 : args.length;
                    Value[] params = new Value[len2 + 2];
                    Class<?>[] types = method.getParameterTypes();
                    params[0] = this.instance;
                    params[1] = Value.createInstance(proxy);
                    for (int i = 0; i < len2; ++i) {
                        Value tmp;
                        params[i + 2] = tmp = Java.convert(args[i], types[i]);
                    }
                    OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
                    return Java.unconvert(NativeApply.apply(clos, params), method.getReturnType());
                }
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5");
                }
                int n = len = args == null ? 0 : args.length;
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5 A");
                }
                Value[] params = new Value[len + 1];
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5 B");
                }
                Class<?>[] types = method.getParameterTypes();
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5 C");
                }
                params[0] = this.instance;
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5 D");
                }
                for (int i = 0; i < len; ++i) {
                    if (Debug.ENABLED) {
                        System.out.println("XXX proxy/invoke/5 E");
                    }
                    Value tmp = Java.convert(args[i], types[i]);
                    if (Debug.ENABLED) {
                        System.out.println("XXX proxy/invoke/5 F");
                    }
                    params[i + 1] = tmp;
                    if (!Debug.ENABLED) continue;
                    System.out.println("XXX proxy/invoke/5 G");
                }
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5 H");
                }
                OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5 I");
                }
                Value tmp_apply = NativeApply.apply(clos, params);
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5 J");
                }
                Object tmp_unconverted = Java.unconvert(tmp_apply, method.getReturnType());
                if (Debug.ENABLED) {
                    System.out.println("XXX proxy/invoke/5 K " + tmp_unconverted);
                }
                return tmp_unconverted;
            }
            catch (Throwable t) {
                if (Debug.ENABLED) {
                    System.out.println("*** XXX in Java.invoke/proxy:");
                    t.printStackTrace(System.out);
                }
                throw t;
            }
        }
    }
}

