/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.DataFormat;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class MarshalIntern
implements DataFormat {
    private MarshalIntern() {
    }

    public static Value inputVal(Context context, DataInput dataInput, boolean bl) throws IOException, Fail.Exception, Fatal.Exception {
        assert (context != null) : "null ctxt";
        assert (dataInput != null) : "null in";
        if (bl && IO.read32s(dataInput) != -2070567234) {
            Fail.failWith("input_value: bad object");
        }
        long l = IO.read32u(dataInput);
        long l2 = IO.read32u(dataInput);
        long l3 = IO.read32u(dataInput);
        long l4 = IO.read32u(dataInput);
        ArrayList<Value> arrayList = l3 != 0L ? new ArrayList<Value>(IntegerUtils.ensure32s(l2)) : null;
        Value value = Value.createBlock(0, Value.UNIT);
        MarshalIntern.internRec(context, dataInput, value, 0L, arrayList);
        return value.get0();
    }

    private static void internRec(Context context, DataInput dataInput, Value value, long l, List<Value> list) throws IOException, Fail.Exception, Fatal.Exception {
        assert (context != null) : "null ctxt";
        assert (dataInput != null) : "null in";
        assert (value != null) : "null d";
        int n = -1;
        long l2 = -1L;
        boolean bl = false;
        Value value2 = null;
        Value value3 = null;
        long l3 = -1L;
        LinkedList<StackItem> linkedList = new LinkedList<StackItem>();
        linkedList.add(0, new StackItem(value, l, 1L, StackOperation.READ_ITEMS));
        block24: while (!linkedList.isEmpty()) {
            StackItem stackItem = (StackItem)linkedList.get(0);
            value3 = stackItem.destValue;
            l3 = stackItem.destIndex;
            StackOperation stackOperation = stackItem.op;
            switch (stackOperation) {
                case FRESH_OID: {
                    if (value2 == null) {
                        value2 = context.getCodeState().getCallback("CamlinternalOO.last_id");
                    }
                    if (value2 == null) continue block24;
                    Value value4 = value2.get0();
                    value3.set(l3, value4);
                    value2.set0(Value.createFromRawValue(value4.getRawValue() + 2L));
                    continue block24;
                }
                case SHIFT: {
                    Value value4 = value3.get(l3 + stackItem.arg);
                    if (value4.isBlock() && value4.getTag() == 249) {
                        value4.setParent(value3.asBlock());
                    }
                    value3.set(l3, value4);
                    linkedList.remove(0);
                    continue block24;
                }
                case READ_ITEMS: {
                    stackItem.destIndex++;
                    stackItem.arg--;
                    if (stackItem.arg == 0L) {
                        linkedList.remove(0);
                    }
                    Value value4 = null;
                    int n2 = IO.read8u(dataInput);
                    switch (n2) {
                        case 0: {
                            value4 = Value.createLong(IO.read8s(dataInput));
                            break;
                        }
                        case 1: {
                            value4 = Value.createLong(IO.read16s(dataInput));
                            break;
                        }
                        case 2: {
                            value4 = Value.createLong(IO.read32s(dataInput));
                            break;
                        }
                        case 3: {
                            value4 = Value.createLong(IO.read64s(dataInput));
                            break;
                        }
                        case 4: {
                            value4 = list.get(list.size() - IO.read8u(dataInput));
                            break;
                        }
                        case 5: {
                            value4 = list.get(list.size() - IO.read16u(dataInput));
                            break;
                        }
                        case 6: {
                            value4 = list.get(list.size() - IntegerUtils.ensure32s(IO.read32u(dataInput)));
                            break;
                        }
                        case 8: {
                            long l4 = IO.read32s(dataInput);
                            n = BlockValue.tagFromHeader(l4);
                            l2 = BlockValue.wosizeFromHeader(l4);
                            bl = true;
                            break;
                        }
                        case 19: {
                            long l4 = IO.read64s(dataInput);
                            n = BlockValue.tagFromHeader(l4);
                            l2 = BlockValue.wosizeFromHeader(l4);
                            bl = true;
                            break;
                        }
                        case 9: {
                            value4 = MarshalIntern.readString(dataInput, IO.read8u(dataInput), list);
                            break;
                        }
                        case 10: {
                            value4 = MarshalIntern.readString(dataInput, IntegerUtils.ensure32s(IO.read32u(dataInput)), list);
                            break;
                        }
                        case 11: 
                        case 12: {
                            boolean bl2;
                            if (n2 != 11) {
                                bl2 = true;
                            } else {
                                if (n2 != 12) {
                                    // empty if block
                                }
                                bl2 = false;
                            }
                            value4 = MarshalIntern.readDouble(dataInput, bl2, list);
                            break;
                        }
                        case 13: 
                        case 14: {
                            boolean bl3;
                            if (n2 != 13) {
                                bl3 = true;
                            } else {
                                if (n2 != 14) {
                                    // empty if block
                                }
                                bl3 = false;
                            }
                            value4 = MarshalIntern.readDoubleArray(dataInput, bl3, IO.read8u(dataInput), list);
                            break;
                        }
                        case 7: 
                        case 15: {
                            boolean bl4;
                            if (n2 != 15) {
                                bl4 = true;
                            } else {
                                if (n2 != 7) {
                                    // empty if block
                                }
                                bl4 = false;
                            }
                            value4 = MarshalIntern.readDoubleArray(dataInput, bl4, IntegerUtils.ensure32s(IO.read32u(dataInput)), list);
                            break;
                        }
                        case 16: {
                            long l4 = IO.read32s(dataInput);
                            byte[] byArray = new byte[16];
                            dataInput.readFully(byArray);
                            Value value5 = context.getCodeState().resolveFragment(byArray, l4);
                            if (value5 == null) {
                                String string = String.format("input_value: unknown code module %02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X", byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7], byArray[8], byArray[9], byArray[10], byArray[11], byArray[12], byArray[13], byArray[14], byArray[15]);
                                Fail.failWith(string);
                                break;
                            }
                            value4 = value5;
                            break;
                        }
                        case 17: {
                            int n3 = IntegerUtils.ensure32s(IO.read32u(dataInput));
                            linkedList.add(0, new StackItem(value3, l3, n3 / 8, StackOperation.SHIFT));
                            linkedList.add(0, new StackItem(value3, l3, 1L, StackOperation.READ_ITEMS));
                            continue block24;
                        }
                        case 18: {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            byte by = dataInput.readByte();
                            while (by != 0) {
                                byteArrayOutputStream.write(by);
                                by = dataInput.readByte();
                            }
                            String string = EncodingUtils.convertBytesToString(byteArrayOutputStream.toByteArray());
                            byteArrayOutputStream.close();
                            CustomOperations customOperations = context.getCodeState().findCustom(string);
                            if (customOperations == null) {
                                Fail.failWith("input_value: unknown custom block identifier");
                            }
                            CustomOperations.DeserializedValue deserializedValue = customOperations.deserialize(dataInput);
                            if (list != null) {
                                list.add(deserializedValue.value);
                            }
                            value4 = deserializedValue.value;
                            break;
                        }
                        default: {
                            if (n2 >= 32 && n2 < 64) {
                                value4 = MarshalIntern.readString(dataInput, n2 & 0x1F, list);
                                break;
                            }
                            if (n2 >= 64 && n2 < 128) {
                                value4 = Value.createLong(n2 & 0x3F);
                                break;
                            }
                            if (n2 >= 128) {
                                n = n2 & 0xF;
                                l2 = n2 >> 4 & 7;
                                bl = true;
                                break;
                            }
                            Fail.failWith("input_value: ill-formed message");
                            return;
                        }
                    }
                    if (bl) {
                        if (l2 == 0L) {
                            value4 = context.getCodeState().getAtom(n);
                        } else {
                            value4 = Value.createBlock(n, l2);
                            if (list != null) {
                                list.add(value4);
                            }
                            if (n == 248) {
                                linkedList.add(0, new StackItem(value4, 2L, l2 - 2L, StackOperation.READ_ITEMS));
                                linkedList.add(0, new StackItem(value4, 1L, 1L, StackOperation.FRESH_OID));
                                linkedList.add(0, new StackItem(value4, 0L, 2L, StackOperation.READ_ITEMS));
                            } else {
                                linkedList.add(0, new StackItem(value4, 0L, l2, StackOperation.READ_ITEMS));
                            }
                        }
                        bl = false;
                    }
                    if (value4.isBlock() && value4.getTag() == 249) {
                        value4.setParent(value3.asBlock());
                    }
                    value3.set(l3, value4);
                    continue block24;
                }
            }
            assert (false) : "should not happen";
        }
    }

    private static Value readString(DataInput dataInput, int n, List<Value> list) throws IOException {
        assert (dataInput != null) : "null in";
        assert (n >= 0) : "len should be >= 0";
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        Value value = Value.createString(byArray);
        if (list != null) {
            list.add(value);
        }
        return value;
    }

    private static Value readDouble(DataInput dataInput, boolean bl, List<Value> list) throws IOException {
        assert (dataInput != null) : "null in";
        long l = IO.read64s(dataInput);
        double d = Double.longBitsToDouble(bl ? Long.reverseBytes(l) : l);
        Value value = Value.createDouble(d);
        if (list != null) {
            list.add(value);
        }
        return value;
    }

    private static Value readDoubleArray(DataInput dataInput, boolean bl, int n, List<Value> list) throws IOException {
        assert (dataInput != null) : "null in";
        assert (n >= 0) : "len should be >= 0";
        Value value = Value.createDoubleArray(n);
        if (list != null) {
            list.add(value);
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                long l = IO.read64s(dataInput);
                value.setDouble(i, Double.longBitsToDouble(Long.reverseBytes(l)));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                long l = IO.read64s(dataInput);
                value.setDouble(i, Double.longBitsToDouble(l));
            }
        }
        return value;
    }

    private static final class StackItem {
        private final Value destValue;
        private long destIndex;
        private long arg;
        private final StackOperation op;

        StackItem(Value value, long l, long l2, StackOperation stackOperation) {
            this.destValue = value;
            this.destIndex = l;
            this.arg = l2;
            this.op = stackOperation;
        }
    }

    private static enum StackOperation {
        READ_ITEMS,
        FRESH_OID,
        SHIFT;

    }
}

