/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XYData
implements XYDataset,
IntervalXYDataset {
    static HashMap datasetMap = new HashMap();
    static int id = 0;
    String name = "";
    DatasetGroup dGroup = new DatasetGroup();
    ArrayList xSeries = new ArrayList();
    ArrayList ySeries = new ArrayList();
    ArrayList ySeriesNames = new ArrayList();
    double deltaX = 0.9;
    double deltaY = 0.15;

    public XYData() {
        this.name = "xyData" + id;
        datasetMap.put(this.name, this);
        ++id;
    }

    public XYData(String name) {
        this.name = name;
        datasetMap.put(name, this);
    }

    public static void remove(String name) {
        datasetMap.remove(name);
    }

    void remove() {
        datasetMap.remove(this.name);
    }

    public static XYData get(String name) {
        return (XYData)datasetMap.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setDeltaX(double value) {
        this.deltaX = value;
    }

    public void setXValues(ArrayList<Double> xValues, int series) {
        for (int i = this.xSeries.size(); i <= series; ++i) {
            this.xSeries.add(null);
        }
        this.xSeries.set(series, xValues);
    }

    public void setXValues(ArrayList<Double> xValues) {
        this.xSeries.clear();
        this.xSeries.add(xValues);
    }

    public void setYValues(ArrayList<Double> yValues, int series, String seriesName) {
        for (int i = this.ySeries.size(); i <= series; ++i) {
            this.ySeries.add(null);
            this.ySeriesNames.add("");
        }
        this.ySeries.set(series, yValues);
        this.ySeriesNames.set(series, seriesName);
    }

    public void setYValues(ArrayList<Double> yValues) {
        this.ySeries.clear();
        this.ySeries.add(yValues);
        this.ySeriesNames.clear();
        this.ySeriesNames.add("");
    }

    public void addChangeListener(DatasetChangeListener listener) {
    }

    public void removeChangeListener(DatasetChangeListener listener) {
    }

    public DatasetGroup getGroup() {
        return this.dGroup;
    }

    public void setGroup(DatasetGroup group) {
        this.dGroup = group;
    }

    public int getSeriesCount() {
        return this.ySeries.size();
    }

    public String getSeriesName(int series) {
        return (String)this.ySeriesNames.get(series);
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    public int getItemCount(int series) {
        ArrayList yData = (ArrayList)this.ySeries.get(series);
        if (yData != null) {
            return yData.size();
        }
        return 0;
    }

    public int getItemCount() {
        ArrayList yData;
        int count = 0;
        if (this.ySeries.size() > 0 && (yData = (ArrayList)this.ySeries.get(0)) != null) {
            count = yData.size();
        }
        return count;
    }

    public Comparable getSeriesKey(int series) {
        return this.getSeriesName(series);
    }

    public int indexOf(Comparable seriesKey) {
        return this.ySeriesNames.indexOf(seriesKey);
    }

    public double getEndYValue(int series, int item) {
        double yValue = this.getYValue(series, item);
        return yValue + this.deltaY / 2.0;
    }

    public Number getEndY(int series, int item) {
        double yValue = this.getEndYValue(series, item);
        return new Double(yValue);
    }

    public double getStartYValue(int series, int item) {
        double yValue = this.getYValue(series, item);
        return yValue - this.deltaY / 2.0;
    }

    public Number getStartY(int series, int item) {
        double yValue = this.getStartYValue(series, item);
        return new Double(yValue);
    }

    public double getEndXValue(int series, int item) {
        double xValue = this.getXValue(series, item);
        return xValue + this.deltaX / 2.0;
    }

    public Number getEndX(int series, int item) {
        double xValue = this.getEndXValue(series, item);
        return new Double(xValue);
    }

    public double getStartXValue(int series, int item) {
        double xValue = this.getXValue(series, item);
        return xValue - this.deltaX / 2.0;
    }

    public Number getStartX(int series, int item) {
        double xValue = this.getStartXValue(series, item);
        return new Double(xValue);
    }
}

