/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.chart.XYTableStatsData;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StatisticalXYRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8135673815876552516L;

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Number x = dataset.getX(series, item);
        if (x == null) {
            return;
        }
        double xdouble = x.doubleValue();
        if (!domainAxis.getRange().contains(xdouble)) {
            return;
        }
        double xx = domainAxis.valueToJava2D(xdouble, dataArea, plot.getDomainAxisEdge());
        Rectangle2D.Double entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge location = plot.getRangeAxisEdge();
        Color itemPaint = Color.BLACK;
        Stroke itemStroke = this.getItemStroke(series, item);
        g2.setPaint(itemPaint);
        g2.setStroke(itemStroke);
        if (dataset instanceof XYTableStatsData) {
            XYTableStatsData sData = (XYTableStatsData)dataset;
            double delta = 2.0;
            if (domainAxis.isInverted()) {
                delta = -delta;
            }
            double mean = sData.getMeanValue(series, item);
            double sDev = sData.getSDevValue(series, item);
            double yHigh = mean + sDev / 2.0;
            double yLow = mean - sDev / 2.0;
            if (!Double.isNaN(yHigh) && !Double.isNaN(yLow)) {
                double yyHigh = rangeAxis.valueToJava2D(yHigh, dataArea, location);
                double yyMean = rangeAxis.valueToJava2D(mean, dataArea, location);
                double yyLow = rangeAxis.valueToJava2D(yLow, dataArea, location);
                if (orientation == PlotOrientation.HORIZONTAL) {
                    g2.draw(new Line2D.Double(yyLow, xx, yyHigh, xx));
                    g2.draw(new Line2D.Double(yyMean, xx + delta, yyMean, xx - delta));
                    entityArea = new Rectangle2D.Double(Math.min(yyLow, yyHigh), xx - 1.0, Math.abs(yyHigh - yyLow), 2.0);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    g2.draw(new Line2D.Double(xx, yyLow, xx, yyHigh));
                    g2.draw(new Line2D.Double(xx - delta, yyMean, xx + delta, yyMean));
                    entityArea = new Rectangle2D.Double(xx - 1.0, Math.min(yyLow, yyHigh), 2.0, Math.abs(yyHigh - yyLow));
                }
            }
        } else if (item > 0) {
            Number x0 = dataset.getX(series, item - 1);
            Number y0 = dataset.getY(series, item - 1);
            Number y = dataset.getY(series, item);
            if (x0 == null || y0 == null || y == null) {
                return;
            }
            double xx0 = domainAxis.valueToJava2D(x0.doubleValue(), dataArea, plot.getDomainAxisEdge());
            double yy0 = rangeAxis.valueToJava2D(y0.doubleValue(), dataArea, location);
            double yy = rangeAxis.valueToJava2D(y.doubleValue(), dataArea, location);
            if (orientation == PlotOrientation.HORIZONTAL) {
                g2.draw(new Line2D.Double(yy0, xx0, yy, xx));
            } else if (orientation == PlotOrientation.VERTICAL) {
                g2.draw(new Line2D.Double(xx0, yy0, xx, yy));
            }
        }
        if (entities != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            tip = generator != null ? generator.generateToolTip(dataset, series, item) : series + " " + item;
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(entityArea, dataset, series, item, tip, url);
            entities.add((ChartEntity)entity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StatisticalXYRenderer)) {
            return false;
        }
        return super.equals(obj);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }
}

