/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.SymbolParameter;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.chart.DatasetParameter;
import com.onemoonscientific.swank.chart.DatasetShape;
import com.onemoonscientific.swank.chart.DefaultCategoryData;
import com.onemoonscientific.swank.chart.LegendLocParameter;
import com.onemoonscientific.swank.chart.LegendStateParameter;
import com.onemoonscientific.swank.chart.NumberRange;
import com.onemoonscientific.swank.chart.PlotInterface;
import com.onemoonscientific.swank.chart.PlotLegend;
import com.onemoonscientific.swank.chart.RAutoParameter;
import com.onemoonscientific.swank.chart.RLabelParameter;
import com.onemoonscientific.swank.chart.RMaxParameter;
import com.onemoonscientific.swank.chart.RMinParameter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class CategoryPlotShapeComplete
extends SwkShape
implements DatasetShape,
NumberRange,
PlotInterface {
    static CanvasParameter[] parameters = new CanvasParameter[]{new TagsParameter(), new DatasetParameter(), new FillParameter(), new LegendStateParameter(), new LegendLocParameter(), new RLabelParameter(), new RMinParameter(), new RMaxParameter(), new RAutoParameter(), new TransformerParameter()};
    static Map parameterMap = new TreeMap();
    GeneralPath gPath = new GeneralPath();
    float radius = 2.0f;
    int symbolType = 3;
    boolean drawLine = false;
    CategoryPlot plot = new CategoryPlot();
    PlotLegend plotLegend = new PlotLegend((LegendItemSource)this.plot);
    ChartRenderingInfo chartInfo = new ChartRenderingInfo();
    PlotRenderingInfo state = new PlotRenderingInfo(this.chartInfo);
    Rectangle2D.Double plotArea = null;
    Rectangle2D rect2D = null;
    RectangleEdge edge = RectangleEdge.BOTTOM;
    String plotType = "barplot";
    CategoryItemRenderer renderer = null;
    String legendLoc = "s.n";
    boolean legendState = false;

    public CategoryPlotShapeComplete() {
        this.rect2D = new Rectangle2D.Double();
        this.plot.setDataset((CategoryDataset)new DefaultCategoryData());
        this.plot.setDomainAxis(new CategoryAxis());
        this.plot.setRangeAxis((ValueAxis)new NumberAxis());
        this.setRenderer("render");
        this.setShape(this.rect2D);
    }

    public String getType() {
        return this.plotType;
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setRenderer(String renderName) {
        this.renderer = new BarRenderer();
        this.plot.setRenderer(this.renderer);
    }

    public void setDataset(String name) {
        DefaultCategoryData categoryData = DefaultCategoryData.get(name);
        this.plot.setDataset((CategoryDataset)categoryData);
    }

    public void setDataset(int index, String name) {
        DefaultCategoryData categoryData = DefaultCategoryData.get(name);
        this.plot.setDataset(index, (CategoryDataset)categoryData);
    }

    public void setDrawline(boolean newValue) {
        this.drawLine = newValue;
    }

    public boolean getDrawline() {
        return this.drawLine;
    }

    public void setSymbolType(int newSymbolType) {
        this.symbolType = newSymbolType;
    }

    public String getSymbolType() {
        return SymbolParameter.getSymbolType((int)this.symbolType);
    }

    public void setRadius(double newRadius) {
        this.radius = (float)newRadius;
    }

    public double getRadius() {
        return this.radius;
    }

    public String getLegendLoc() {
        return this.legendLoc;
    }

    public void setLegendLoc(String loc) {
        this.legendLoc = loc;
    }

    public boolean getLegendState() {
        return this.legendState;
    }

    public void setLegendState(boolean state) {
        this.legendState = state;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 4) {
            throw new SwkException("wrong # coordinates: expected 8, got " + coords.length);
        }
        this.gPath.reset();
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        this.checkCoordinates(this.storeCoords);
        this.rect2D.setFrame(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2] - this.storeCoords[0], this.storeCoords[3] - this.storeCoords[1]);
        AffineTransform aT = new AffineTransform();
        aT.translate(this.storeCoords[0], this.storeCoords[1]);
        aT.shear(this.getXShear(), this.getYShear());
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        aT.rotate(this.getRotate(), (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        this.plotArea = new Rectangle2D.Double();
        this.plotArea.setFrameFromDiagonal(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2], this.storeCoords[3]);
    }

    public void checkCoordinates(double[] coords) {
        double hold;
        if (coords == null || coords.length != 4) {
            return;
        }
        if (coords[0] > coords[2]) {
            hold = coords[0];
            coords[0] = coords[2];
            coords[2] = hold;
        }
        if (coords[1] > coords[3]) {
            hold = coords[1];
            coords[1] = coords[3];
            coords[3] = hold;
        }
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public void paintShape(Graphics2D g2) {
        Point2D.Double anchor = new Point2D.Double();
        this.applyCoordinates();
        Rectangle2D plotAreaNow = (Rectangle2D)this.plotArea.clone();
        AffineTransform shapeTransform = this.getTransform();
        if (shapeTransform != null) {
            plotAreaNow = shapeTransform.createTransformedShape(plotAreaNow).getBounds2D();
        }
        if (this.legendState) {
            Rectangle2D legendArea = this.plotLegend.arrangeLegend(g2, plotAreaNow);
            this.plot.draw(g2, plotAreaNow, (Point2D)anchor, null, this.state);
            this.plotLegend.drawLegend(g2, legendArea);
        } else {
            this.plot.draw(g2, plotAreaNow, (Point2D)anchor, null, this.state);
        }
    }

    public boolean hitShape(double x, double y) {
        Rectangle bounds;
        boolean hit = false;
        Shape checkShape = this.getShape();
        AffineTransform shapeTransform = this.getTransform();
        if (shapeTransform != null) {
            checkShape = shapeTransform.createTransformedShape(checkShape);
        }
        if ((bounds = checkShape.getBounds()).contains(x, y)) {
            hit = true;
        }
        return hit;
    }

    public void addSymbol(float x1, float y1, float radius) {
    }

    public TclObject getDatasets(Interp interp) throws TclException {
        int nDatasets = this.plot.getDatasetCount();
        TclObject list = TclList.newInstance();
        for (int i = 0; i < nDatasets; ++i) {
            DefaultCategoryData catData = (DefaultCategoryData)this.plot.getDataset(i);
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)catData.getName()));
        }
        return list;
    }

    public void updateDatasets(String[] datasetNames) {
        int nDatasets = this.plot.getDatasetCount();
        for (int i = 0; i < datasetNames.length; ++i) {
            this.setDataset(i, datasetNames[i]);
            if (i < nDatasets) continue;
            BarRenderer newRenderer = new BarRenderer();
            this.plot.setRenderer(i, (CategoryItemRenderer)newRenderer);
        }
    }

    public TclObject getColors(Interp interp) throws TclException {
        TclObject list = TclList.newInstance();
        return list;
    }

    public void updateColors(Color[] colors) {
    }

    public CategoryAxis getDomainAxis() {
        return this.plot.getDomainAxis();
    }

    public NumberAxis getRangeAxis() {
        return (NumberAxis)this.plot.getRangeAxis();
    }

    static {
        CategoryPlotShapeComplete.initializeParameters((CanvasParameter[])parameters, (Map)parameterMap);
    }
}

