/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas3D;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import com.onemoonscientific.swank.canvas3D.SwkCanvas;
import com.onemoonscientific.swank.canvas3D.SwkCone;
import com.onemoonscientific.swank.canvas3D.SwkCylinder;
import com.onemoonscientific.swank.canvas3D.SwkImageCanvas;
import com.onemoonscientific.swank.canvas3D.SwkShape;
import com.onemoonscientific.swank.canvas3D.SwkShapeItemGet;
import com.onemoonscientific.swank.canvas3D.SwkSphere;
import com.onemoonscientific.swank.canvas3D.SwkText2D;
import com.onemoonscientific.swank.canvas3D.Transformer;
import java.awt.Component;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class SwkCanvasWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "object", "jadd", "create", "itemconfigure", "coords", "hit", "itemcget", "find", "move", "scale", "delete", "addtag", "bind", "raise", "lower", "dtag", "gettags", "canvasx", "canvasy", "copy", "index", "newtype", "bbox", "type", "zoom", "transformer", "view", "center", "transform"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_OBJECT = 2;
    private static final int OPT_JADD = 3;
    private static final int OPT_CREATE = 4;
    private static final int OPT_ITEMCONFIG = 5;
    private static final int OPT_COORDS = 6;
    private static final int OPT_HIT = 7;
    private static final int OPT_ITEMCGET = 8;
    private static final int OPT_FIND = 9;
    private static final int OPT_MOVE = 10;
    private static final int OPT_SCALE = 11;
    private static final int OPT_DELETE = 12;
    private static final int OPT_ADDTAG = 13;
    private static final int OPT_BIND = 14;
    private static final int OPT_RAISE = 15;
    private static final int OPT_LOWER = 16;
    private static final int OPT_DTAG = 17;
    private static final int OPT_GETTAGS = 18;
    private static final int OPT_CANVASX = 19;
    private static final int OPT_CANVASY = 20;
    private static final int OPT_COPY = 21;
    private static final int OPT_INDEX = 22;
    private static final int OPT_NEWTYPE = 23;
    private static final int OPT_BBOX = 24;
    private static final int OPT_TYPE = 25;
    private static final int OPT_ZOOM = 26;
    private static final int OPT_TRANSFORMER = 27;
    private static final int OPT_VIEW = 28;
    private static final int OPT_CENTER = 29;
    private static final int OPT_TRANSFORM = 30;
    static boolean gotDefaults = false;
    Map newTypes = new HashMap();
    Interp interp = null;

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        this.interp = interp;
        int opt = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"option", (int)0);
        TclObject tObj = (TclObject)Widgets.getWidget((Interp)interp, (String)argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkCanvas swkcanvas = (SwkCanvas)ReflectObject.get((Interp)interp, (TclObject)tObj);
        SwkImageCanvas swkImageCanvas = swkcanvas.getSwkImageCanvas();
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkcanvas.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkcanvas.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkcanvas.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkcanvas.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkCanvas.resourceDB.get(argv[2].toString());
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkcanvas.configure(interp, argv, 2);
                break;
            }
            case 2: {
                interp.setResult(tObj);
                break;
            }
            case 3: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                SwkCanvasWidgetCmd.jadd(interp, swkcanvas, argv[2]);
                break;
            }
            case 4: {
                this.create(interp, swkImageCanvas, argv);
                break;
            }
            case 5: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                if (argv.length == 3) {
                    interp.setResult(new SwkShapeItemGet(interp, swkImageCanvas, argv[2].toString(), null).exec(true));
                    break;
                }
                if (argv.length == 4) {
                    interp.setResult(new SwkShapeItemGet(interp, swkImageCanvas, argv[2].toString(), argv[3].toString()).exec(true));
                    break;
                }
                SwkShape.config(interp, swkImageCanvas, argv, 3);
                break;
            }
            case 22: {
                new Index().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 8: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(new SwkShapeItemGet(interp, swkImageCanvas, argv[2].toString(), argv[3].toString()).exec(false));
                break;
            }
            case 6: {
                this.coords(interp, swkImageCanvas, argv);
                break;
            }
            case 7: {
                new Hit().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 9: {
                new Search().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 12: {
                new Delete().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 15: {
                new RaiseOrLower().raise(interp, swkImageCanvas, argv);
                break;
            }
            case 16: {
                new RaiseOrLower().lower(interp, swkImageCanvas, argv);
                break;
            }
            case 10: {
                new Move().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 17: {
                new DTags().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 13: {
                new AddTag().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 18: {
                new GetTags().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 14: {
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                SwkBinding binding = SwkBind.getBinding((Interp)interp, (TclObject[])argv, (int)3);
                if (binding == null) break;
                SwkBind.updateBindingCommand((Interp)interp, (SwkBinding)binding, (TclObject[])argv, (int)3);
                swkcanvas.setupBinding(interp, binding, argv[2].toString());
                break;
            }
            case 11: {
                new Scale().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 26: {
                new Zoom().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 19: 
            case 20: {
                this.canvasXY(interp, swkcanvas, argv);
                break;
            }
            case 21: {
                new Copy().exec(interp, swkcanvas, argv);
                break;
            }
            case 23: {
                this.newType(interp, argv);
                break;
            }
            case 24: {
                new BBox().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 25: {
                new Type().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 27: {
                new TransformerSet().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 28: {
                if (argv.length != 2 && argv.length != 6) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                if (argv.length == 6) {
                    if (argv[2].toString().equals("eye")) {
                        float x = (float)TclDouble.get((Interp)interp, (TclObject)argv[3]);
                        float y = (float)TclDouble.get((Interp)interp, (TclObject)argv[4]);
                        float z = (float)TclDouble.get((Interp)interp, (TclObject)argv[5]);
                        swkImageCanvas.setEyePosition(x, y, z);
                        break;
                    }
                    if (argv[2].toString().equals("center")) {
                        float x = (float)TclDouble.get((Interp)interp, (TclObject)argv[3]);
                        float y = (float)TclDouble.get((Interp)interp, (TclObject)argv[4]);
                        float z = (float)TclDouble.get((Interp)interp, (TclObject)argv[5]);
                        swkImageCanvas.setViewCenter(x, y, z);
                        break;
                    }
                    if (!argv[2].toString().equals("up")) break;
                    float x = (float)TclDouble.get((Interp)interp, (TclObject)argv[3]);
                    float y = (float)TclDouble.get((Interp)interp, (TclObject)argv[4]);
                    float z = (float)TclDouble.get((Interp)interp, (TclObject)argv[5]);
                    swkImageCanvas.setUpDirection(x, y, z);
                    break;
                }
                Transform3D t3 = new Transform3D();
                TransformGroup tG = swkImageCanvas.universe.getViewingPlatform().getViewPlatformTransform();
                tG.getTransform(t3);
                interp.setResult(t3.toString());
                break;
            }
            case 29: {
                if (argv.length != 2 && argv.length != 5) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                if (argv.length == 5) {
                    double x = TclDouble.get((Interp)interp, (TclObject)argv[2]);
                    double y = TclDouble.get((Interp)interp, (TclObject)argv[3]);
                    double z = TclDouble.get((Interp)interp, (TclObject)argv[4]);
                    swkImageCanvas.setCenter((float)x, (float)y, (float)z);
                    break;
                }
                interp.setResult(TclDouble.get((Interp)interp, (TclObject)argv[2]));
                break;
            }
            case 30: {
                if (argv.length != 3 && argv.length != 6) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                if (!argv[2].toString().equals("reset")) break;
                swkImageCanvas.resetTransform();
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    public static void jadd(Interp interp, SwkCanvas swkcanvas, TclObject tclObject) throws TclException {
        Object object;
        TclObject tObj = (TclObject)Widgets.getWidget((Interp)interp, (String)tclObject.toString());
        if (tObj != null && (object = ReflectObject.get((Interp)interp, (TclObject)tObj)) instanceof PopupMenu) {
            swkcanvas.add((PopupMenu)object);
            return;
        }
        if (tObj == null) {
            throw new TclException(interp, "Object not found");
        }
    }

    int findCoords(Interp interp, TclObject[] argv, int start) throws TclException {
        int lastCoord = 0;
        for (int i = start; i < argv.length; ++i) {
            lastCoord = i;
            if (!argv[i].toString().startsWith("-") || Character.isDigit(argv[i].toString().charAt(1))) continue;
            lastCoord = i - 1;
            break;
        }
        return lastCoord;
    }

    double[] getCoords(Interp interp, SwkImageCanvas canvas, TclObject[] argv, int start, int lastCoord) throws TclException {
        int nCoords = lastCoord - start + 1;
        double[] coords = null;
        if (nCoords == 1) {
            TclObject[] coordList = TclList.getElements((Interp)interp, (TclObject)argv[start]);
            if (coordList == null || coordList.length == 0) {
                return null;
            }
            coords = new double[coordList.length];
            for (int i = 0; i < coords.length; ++i) {
                coords[i] = SwankUtil.getTkSizeD((Interp)interp, (Component)canvas.getComponent(), (TclObject)coordList[i]);
            }
        } else {
            coords = new double[nCoords];
            for (int i = start; i <= lastCoord; ++i) {
                coords[i - start] = SwankUtil.getTkSizeD((Interp)interp, (Component)canvas.getComponent(), (TclObject)argv[i]);
            }
        }
        return coords;
    }

    void coords(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        if (argv.length == 3) {
            new CoordsGet().exec(interp, swkcanvas, argv);
        } else {
            new CoordsSet().exec(interp, swkcanvas, argv);
        }
    }

    void create(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
        Object shapeList = null;
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "type coords ?arg arg ...?");
        }
        if (argv.length < 4) {
            throw new TclNumArgsException(interp, 3, argv, "coords ?arg arg ...?");
        }
        int lastCoord = this.findCoords(interp, argv, 3);
        double[] coordArray = this.getCoords(interp, swkcanvas, argv, 3, lastCoord);
        try {
            SwkShape swkShape;
            if (argv[2].toString().equals("sphere")) {
                if (argv.length < 6) {
                    throw new TclNumArgsException(interp, 3, argv, "option");
                }
                if ((argv.length - 6) % 2 != 0) {
                    throw new TclNumArgsException(interp, 3, argv, "option");
                }
                SwkSphere swkSphere = new SwkSphere(swkcanvas);
                swkShape = swkSphere;
            } else if ("cylinder".startsWith(argv[2].toString())) {
                if (argv.length < 9) {
                    throw new TclNumArgsException(interp, 3, argv, "option");
                }
                if ((argv.length - 9) % 2 != 0) {
                    throw new TclNumArgsException(interp, 3, argv, "option");
                }
                SwkCylinder swkCylinder = new SwkCylinder(swkcanvas);
                swkShape = swkCylinder;
            } else if ("cone".startsWith(argv[2].toString())) {
                if (argv.length < 9) {
                    throw new TclNumArgsException(interp, 3, argv, "option");
                }
                if ((argv.length - 9) % 2 != 0) {
                    throw new TclNumArgsException(interp, 3, argv, "option");
                }
                SwkCone swkCone = new SwkCone(swkcanvas);
                swkShape = swkCone;
            } else if ("text2d".startsWith(argv[2].toString())) {
                if (argv.length < 6) {
                    throw new TclNumArgsException(interp, 3, argv, "option");
                }
                if ((argv.length - 6) % 2 != 0) {
                    throw new TclNumArgsException(interp, 3, argv, "option");
                }
                SwkText2D swkText2D = new SwkText2D(swkcanvas);
                swkShape = swkText2D;
            } else {
                CanvasType canvasType = (CanvasType)this.newTypes.get(argv[2].toString());
                if (canvasType == null) {
                    throw new TclException(interp, "canvas type \"" + argv[2].toString() + "\" doesn't exist");
                }
                Object newObject = null;
                try {
                    newObject = canvasType.myTypeClass.newInstance();
                }
                catch (InstantiationException iE) {
                    throw new TclException(interp, "class " + argv[2].toString() + " can't be instantiated");
                }
                catch (IllegalAccessException iaE) {
                    throw new TclException(interp, "illegal access to class for object \"" + argv[2].toString() + "\"");
                }
                if (!(newObject instanceof SwkShape)) {
                    throw new TclException(interp, "class for object \"" + argv[2].toString() + "\" is not instance of SwkShape");
                }
                if (coordArray.length < canvasType.myNCoords) {
                    throw new TclException(interp, "wrong # coordinates: expected at least 4, got " + coordArray.length);
                }
                if (coordArray.length % 2 != 0) {
                    throw new TclException(interp, "wrong # coordinates: expected an even number, got " + coordArray.length);
                }
                swkShape = newObject;
                swkShape.setCanvas(swkcanvas);
            }
            if (swkShape != null) {
                swkShape.coords(swkcanvas, coordArray);
                swkShape.configShape(interp, swkcanvas, argv, lastCoord + 1);
                this.addShape(swkcanvas, swkShape);
                interp.setResult(swkShape.id);
            }
        }
        catch (SwkException swkE) {
            throw new TclException(interp, swkE.getMessage());
        }
        swkcanvas.repaint(50);
    }

    void createOld(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
        Object shapeList = null;
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "type coords ?arg arg ...?");
        }
        if (argv.length < 4) {
            throw new TclNumArgsException(interp, 3, argv, "coords ?arg arg ...?");
        }
        int lastCoord = this.findCoords(interp, argv, 3);
        double[] coordArray = this.getCoords(interp, swkcanvas, argv, 3, lastCoord);
        int n = coordArray.length / 3;
        float[] coords = new float[n * 3];
        float[] colors = new float[n * 3];
        float[] radii = new float[n];
        for (int iElem = 0; iElem < n; ++iElem) {
            coords[iElem * 3] = (float)coordArray[iElem];
            coords[iElem * 3 + 1] = (float)coordArray[iElem * 3 + 1];
            coords[iElem * 3 + 2] = (float)coordArray[iElem * 3 + 2];
            colors[iElem * 3] = 1.0f;
            colors[iElem * 3 + 1] = 1.0f;
            colors[iElem * 3 + 2] = 1.0f;
            radii[iElem] = 1.0f;
        }
        int id = swkcanvas.addSpheres(coords, colors, radii);
        id = swkcanvas.addLines2(coords, colors, 0, n * 3);
        if (id < 0) {
            throw new TclException(interp, "couldn't add lines, no scene or root");
        }
        interp.setResult(id);
        swkcanvas.repaint(50);
    }

    void addShape(SwkImageCanvas swkcanvas, SwkShape swkShape) {
        swkShape.id = swkcanvas.lastShapeId++;
        new AddShape().exec(swkcanvas, swkShape);
    }

    void canvasXY(Interp interp, SwkCanvas swkcanvas, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        if (argv.length == 4) {
            double grid = SwankUtil.getTkSizeD((Interp)interp, (Component)swkcanvas, (TclObject)argv[3]);
            double x = TclDouble.get((Interp)interp, (TclObject)argv[2]);
            interp.setResult((int)((double)Math.round(x / grid) * grid));
        } else {
            interp.setResult(TclDouble.get((Interp)interp, (TclObject)argv[2]));
        }
    }

    void newType(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 5) {
            throw new TclNumArgsException(interp, 2, argv, "name class nCoords");
        }
        if (this.newTypes.containsKey(argv[2].toString())) {
            throw new TclException(interp, "type \"" + argv[2].toString() + "\" already exists");
        }
        Class<?> newClass = null;
        try {
            newClass = Class.forName(argv[3].toString());
        }
        catch (ClassNotFoundException cnfE) {
            throw new TclException(interp, "class " + argv[3].toString() + " doesn't exist " + cnfE.toString());
        }
        int nCoords = TclInteger.get((Interp)interp, (TclObject)argv[4]);
        CanvasType canvasType = new CanvasType(newClass, nCoords);
        this.newTypes.put(argv[2].toString(), canvasType);
    }

    static void getResult(Interp interp, ArrayList shapeList) throws TclException {
        TclObject list = TclList.newInstance();
        if (shapeList != null) {
            for (int j = 0; j < shapeList.size(); ++j) {
                int id = (Integer)shapeList.get(j);
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)id));
            }
        }
        interp.setResult(list);
    }

    class Search
    extends GetValueOnEventThread {
        public static final int NEXT = 0;
        public static final int PREVIOUS = 1;
        public static final int ALL = 2;
        public static final int ENCLOSED = 3;
        public static final int OVERLAPPING = 4;
        public static final int WITHTAG = 5;
        public static final int CLOSEST = 6;
        SwkImageCanvas swkcanvas = null;
        String tagName = null;
        SwkShape swkShape = null;
        SwkShape bestShape = null;
        ArrayList shapeList = null;
        String refTag = "";
        int mode = 0;
        Point2D pt = null;
        float halo = 0.0f;
        Rectangle2D rect = null;

        Search() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            Object swkShape = null;
            Object nextShape = null;
            int start = 2;
            if (argv.length < start + 1) {
                throw new TclNumArgsException(interp, 0, argv, "option");
            }
            if (argv[start].toString().equals("above")) {
                if (argv.length != start + 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                this.tagName = argv[start + 1].toString();
                interp.resetResult();
                this.mode = 0;
                this.execOnThread();
                if (swkShape != null) {
                    interp.setResult(swkShape.id);
                }
            } else if (argv[start].toString().equals("all")) {
                if (argv.length != start + 1) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                this.mode = 2;
                this.execOnThread();
                SwkCanvasWidgetCmd.getResult(interp, this.shapeList);
            } else if (argv[start].toString().equals("below")) {
                if (argv.length != start + 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                if (argv.length != start + 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                this.tagName = argv[start + 1].toString();
                interp.resetResult();
                this.mode = 1;
                this.execOnThread();
                if (swkShape != null) {
                    interp.setResult(swkShape.id);
                }
            } else if (argv[start].toString().equals("closest")) {
                if (argv.length < start + 3 || argv.length > start + 5) {
                    throw new TclNumArgsException(interp, 1, argv, "x y ?halo? ?start?");
                }
                float x1 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 1]);
                float y1 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 2]);
                this.refTag = null;
                if (argv.length > start + 3) {
                    this.halo = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 3]);
                    if ((double)this.halo < 0.0) {
                        throw new TclException(interp, "closest: halo cannot be less than 0.0");
                    }
                    if (argv.length > start + 4) {
                        this.refTag = argv[start + 4].toString();
                    }
                }
                this.pt = new Point2D.Float(x1, y1);
                this.mode = 6;
                this.execOnThread();
                if (this.bestShape == null) {
                    interp.setResult("");
                } else {
                    interp.setResult(this.bestShape.id);
                }
            } else if (argv[start].toString().equals("enclosed") || argv[start].toString().equals("overlapping")) {
                Object bounds = null;
                if (argv.length != start + 5) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                float x1 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 1]);
                float y1 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 2]);
                float x2 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 3]);
                float y2 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 4]);
                if (x1 > x2) {
                    throw new TclException(interp, "enclosed: x1 must be less than x2");
                }
                if (y1 > y2) {
                    throw new TclException(interp, "enclosed: y1 must be less than y2");
                }
                this.rect = new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1);
                this.mode = 3;
                if (argv[start].toString().equals("overlapping")) {
                    this.mode = 4;
                }
                this.execOnThread();
                SwkCanvasWidgetCmd.getResult(interp, this.shapeList);
            } else if (argv[start].toString().equals("withtag")) {
                if (argv.length != start + 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                this.refTag = argv[start + 1].toString();
                this.mode = 5;
                this.execOnThread();
                SwkCanvasWidgetCmd.getResult(interp, this.shapeList);
            }
        }

        public void run() {
            try {
                switch (this.mode) {
                    case 0: 
                    case 1: {
                        this.getOne();
                        break;
                    }
                    case 2: {
                        this.getSome();
                        break;
                    }
                    case 6: {
                        this.getClosest();
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.getRectShapes();
                        break;
                    }
                    case 5: {
                        this.withTag();
                        break;
                    }
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }

        void getOne() throws SwkException {
            SwkShape swkShape = this.swkcanvas.getShape(this.tagName);
            if (swkShape != null) {
                swkShape = this.mode == 0 ? swkShape.next : swkShape.previous;
            }
        }

        void getSome() {
            SwkShape swkShape = this.swkcanvas.firstShape;
            SwkShape nextShape = this.swkcanvas.firstShape;
            if (this.swkcanvas.firstShape != null) {
                this.shapeList = new ArrayList();
                while (nextShape != null) {
                    swkShape = nextShape;
                    nextShape = swkShape.next;
                    this.shapeList.add(new Integer(swkShape.id));
                }
            }
        }

        void withTag() throws SwkException {
            Vector shapes = this.swkcanvas.getShapesWithTags(this.refTag);
            this.shapeList = new ArrayList();
            int n = shapes.size();
            for (int i = 0; i < n; ++i) {
                this.shapeList.add(new Integer(((SwkShape)shapes.elementAt((int)i)).id));
            }
        }

        void getClosest() throws SwkException {
        }

        void getRectShapes() {
        }
    }

    class AddShape
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        SwkShape swkShape = null;

        AddShape() {
        }

        void exec(SwkImageCanvas swkcanvas, SwkShape swkShape) {
            this.swkcanvas = swkcanvas;
            this.swkShape = swkShape;
            this.execOnThread();
        }

        public void run() {
            try {
                this.swkcanvas.addShape(this.swkShape);
            }
            catch (SwkException swkE) {
                System.out.println("error adding shape " + swkE.getMessage());
            }
            this.swkcanvas.repaint();
        }
    }

    class CanvasType {
        Class myTypeClass = null;
        int myNCoords = 0;

        CanvasType(Class typeClass, int nCoords) {
            this.myTypeClass = typeClass;
            this.myNCoords = nCoords;
        }
    }

    class TransformerSet
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double[] values = null;
        String name = null;

        TransformerSet() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 10) {
                throw new TclNumArgsException(interp, 2, argv, "transformerName m00 m10 m01 m11 m02 m12");
            }
            this.swkcanvas = swkcanvas;
            double[] values = new double[6];
            for (int i = 4; i < 10; ++i) {
                values[i - 4] = TclDouble.get((Interp)interp, (TclObject)argv[i]);
            }
            this.name = argv[3].toString();
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            Transformer transformer = this.swkcanvas.getTransformer(this.name);
            if (transformer == null) {
                transformer = this.swkcanvas.setTransformer(this.name, null);
            }
            transformer.getTransform().setTransform(this.values[0], this.values[1], this.values[2], this.values[3], this.values[4], this.values[5]);
        }
    }

    class AddTag
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String[] args = null;
        String tagString = null;

        AddTag() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length < 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            this.tagString = argv[2].toString();
            this.args = SwankUtil.argvToStrings((TclObject[])argv, (int)3);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.args);
                String[] tagStrings = new String[]{this.tagString};
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    this.swkcanvas.addTags(tagStrings, swkShape2);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class DTags
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String tagName = null;
        String[] tagStrings = null;

        DTags() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 3 && argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            TclObject[] tagList = TclList.getElements((Interp)interp, (TclObject)argv[argv.length - 1]);
            this.tagStrings = SwankUtil.argvToStrings((TclObject[])tagList, (int)0);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    this.swkcanvas.removeTags(this.tagStrings, false, swkShape2);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Copy
    extends UpdateOnEventThread {
        SwkCanvas swkcanvas = null;

        Copy() {
        }

        void exec(Interp interp, SwkCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            this.execOnThread();
        }

        public void run() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.swkcanvas.copyImageToClipboard(clipboard);
        }
    }

    class Delete
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String[] tags = null;

        Delete() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.tags = SwankUtil.argvToStrings((TclObject[])argv, (int)2);
            this.swkcanvas = swkcanvas;
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                this.swkcanvas.delete(this.tags);
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Index
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        Vector shapeList = null;
        String tagName = "";
        int index = 0;
        SwkShape swkShape = null;

        Index() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "tagOrId arg");
            }
            this.tagName = argv[2].toString();
            if (this.swkShape != null) {
                this.index = this.swkShape.getIndex(interp, argv[3]);
            }
            this.execOnThread();
            interp.setResult(this.index);
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapeList.size() == 0) {
                    return;
                }
                this.swkShape = (SwkShape)shapeList.elementAt(0);
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class GetTags
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        ArrayList tagList = null;
        String tagName = "";

        GetTags() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length != 3) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.tagName = argv[2].toString();
            this.execOnThread();
            TclObject list = TclList.newInstance();
            if (this.tagList != null) {
                int n = this.tagList.size();
                for (int i = 0; i < n; ++i) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)((String)this.tagList.get(i))));
                }
            }
            interp.setResult(list);
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapeList.size() > 0) {
                    SwkShape swkShape = (SwkShape)shapeList.elementAt(0);
                    this.tagList = this.swkcanvas.getTags(swkShape);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Move
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double dX = 0.0;
        double dY = 0.0;
        boolean setValue = false;
        String tagName = null;

        Move() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 5) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            this.dX = SwankUtil.getTkSizeD((Interp)interp, (Component)swkcanvas.getComponent(), (TclObject)argv[3]);
            this.dY = SwankUtil.getTkSizeD((Interp)interp, (Component)swkcanvas.getComponent(), (TclObject)argv[4]);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    swkShape2.move(this.dX, this.dY);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Zoom
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double zoom = 0.0;
        boolean setValue = false;

        Zoom() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 2 && argv.length != 3) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            if (argv.length == 3) {
                this.zoom = TclDouble.get((Interp)interp, (TclObject)argv[2]);
                this.setValue = true;
            }
            this.execOnThread();
            interp.setResult(this.zoom);
            swkcanvas.repaint();
        }

        public void run() {
            if (this.setValue) {
                this.swkcanvas.setZoom(this.zoom);
            }
            this.zoom = this.swkcanvas.getZoom();
        }
    }

    class Scale
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double xOrigin = 0.0;
        double yOrigin = 0.0;
        double xScale = 0.0;
        double yScale = 0.0;
        String tagName = null;

        Scale() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 7) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.tagName = argv[2].toString();
            this.swkcanvas = swkcanvas;
            this.xOrigin = TclDouble.get((Interp)interp, (TclObject)argv[3]);
            this.yOrigin = TclDouble.get((Interp)interp, (TclObject)argv[4]);
            this.xScale = TclDouble.get((Interp)interp, (TclObject)argv[5]);
            this.yScale = TclDouble.get((Interp)interp, (TclObject)argv[6]);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    swkShape2.scale(this.xOrigin, this.yOrigin, this.xScale, this.yScale);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class BBox
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String[] tags = null;
        Rectangle2D rect = null;

        BBox() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 2, argv, "tagOrId ?tagOrId tagOrId ...?");
            }
            this.tags = SwankUtil.argvToStrings((TclObject[])argv, (int)2);
            this.rect = null;
            this.execOnThread();
            if (this.rect != null) {
                TclObject list = TclList.newInstance();
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)this.rect.getX()));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)this.rect.getY()));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)(this.rect.getX() + this.rect.getWidth())));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)(this.rect.getY() + this.rect.getHeight())));
                interp.setResult(list);
            } else {
                interp.setResult("");
            }
        }

        public void run() {
            try {
                this.rect = this.swkcanvas.getShapeBounds(this.tags);
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Type
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String tagName = "";
        String result = "";

        Type() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length != 3) {
                throw new TclNumArgsException(interp, 2, argv, "tagOrId");
            }
            this.tagName = argv[2].toString();
            this.execOnThread();
            interp.setResult(this.result);
        }

        public void run() {
            try {
                SwkShape swkShape;
                Vector shapes = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapes != null && shapes.size() != 0 && (swkShape = (SwkShape)shapes.elementAt(0)) != null) {
                    this.result = swkShape.getType();
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Hit
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double x = 0.0;
        double y = 0.0;
        String tagName = "";
        String result = "";

        Hit() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 5) {
                throw new TclNumArgsException(interp, 2, argv, "item x y");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            this.x = TclDouble.get((Interp)interp, (TclObject)argv[3]);
            this.y = TclDouble.get((Interp)interp, (TclObject)argv[4]);
            this.execOnThread();
            interp.setResult(this.result);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                SwkShape swkShape = this.swkcanvas.getShape(this.tagName);
                if (swkShape == null) return;
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class RaiseOrLower
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        boolean raiseMode = false;
        String shapeArg = null;
        String relativeArg = null;

        RaiseOrLower() {
        }

        void raise(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.raiseMode = true;
            this.doIt(interp, swkcanvas, argv);
        }

        void lower(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.raiseMode = false;
            this.doIt(interp, swkcanvas, argv);
        }

        void doIt(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length != 3 && argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.shapeArg = argv[2].toString();
            if (argv.length == 4) {
                this.relativeArg = argv[3].toString();
            }
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                if (this.raiseMode) {
                    this.swkcanvas.raise(this.shapeArg, this.relativeArg);
                } else {
                    this.swkcanvas.lower(this.shapeArg, this.relativeArg);
                }
            }
            catch (SwkException swkE) {
                SwkCanvasWidgetCmd.this.interp.addErrorInfo(swkE.getMessage());
                SwkCanvasWidgetCmd.this.interp.backgroundError();
            }
        }
    }

    class CoordsSet
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String tagName = "";
        double[] coords = null;

        CoordsSet() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            int lastCoord = SwkCanvasWidgetCmd.this.findCoords(interp, argv, 3);
            this.coords = SwkCanvasWidgetCmd.this.getCoords(interp, swkcanvas, argv, 3, lastCoord);
            this.execOnThread();
        }

        public void run() {
            try {
                SwkShape swkShape;
                Vector shapes = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapes != null && shapes.size() != 0 && (swkShape = (SwkShape)shapes.elementAt(0)) != null) {
                    this.swkcanvas.repaint();
                }
            }
            catch (SwkException swkE) {
                System.out.println("error in coordset");
            }
        }
    }

    class CoordsGet
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String tagName = "";
        double[] coords = null;

        CoordsGet() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 3) {
                throw new TclNumArgsException(interp, 2, argv, "item");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            this.execOnThread();
            TclObject list = TclList.newInstance();
            if (this.coords != null) {
                for (int i = 0; i < this.coords.length; ++i) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)this.coords[i]));
                }
            }
            interp.setResult(list);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                SwkShape swkShape;
                Vector shapes = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapes != null && shapes.size() != 0 && (swkShape = (SwkShape)shapes.elementAt(0)) == null) return;
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }
}

