/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.primitives.stdlib.Lexing;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Parsing", source="byterun/parsing.c")
public final class Parsing {
    private static final int ERRCODE = 256;
    private static final long ACTIONS = 0L;
    private static final long TRANSL_CONST = 1L;
    private static final long TRANSL_BLOCK = 2L;
    private static final long LHS = 3L;
    private static final long LEN = 4L;
    private static final long DEFRED = 5L;
    private static final long DGOTO = 6L;
    private static final long SINDEX = 7L;
    private static final long RINDEX = 8L;
    private static final long GINDEX = 9L;
    private static final long TABLESIZE = 10L;
    private static final long TABLE = 11L;
    private static final long CHECK = 12L;
    private static final long ERROR_FUNCTION = 13L;
    private static final long NAMES_CONST = 14L;
    private static final long NAMES_BLOCK = 15L;
    private static final long S_STACK = 0L;
    private static final long V_STACK = 1L;
    private static final long SYMB_START_STACK = 2L;
    private static final long SYMB_END_STACK = 3L;
    private static final long STACKSIZE = 4L;
    private static final long STACKBASE = 5L;
    private static final long CURR_CHAR = 6L;
    private static final long LVAL = 7L;
    private static final long SYMB_START = 8L;
    private static final long SYMB_END = 9L;
    private static final long ASP = 10L;
    private static final long RULE_LEN = 11L;
    private static final long RULE_NUMBER = 12L;
    private static final long SP = 13L;
    private static final long STATE = 14L;
    private static final long ERRFLAG = 15L;
    private static final int START = 0;
    private static final int TOKEN_READ = 1;
    private static final int STACKS_GROWN_1 = 2;
    private static final int STACKS_GROWN_2 = 3;
    private static final int SEMANTIC_ACTION_COMPUTED = 4;
    private static final int ERROR_DETECTED = 5;
    private static final Value READ_TOKEN = Value.ZERO;
    private static final Value RAISE_PARSE_ERROR = Value.ONE;
    private static final Value GROW_STACKS_1 = Value.TWO;
    private static final Value GROW_STACKS_2 = Value.THREE;
    private static final Value COMPUTE_SEMANTIC_ACTION = Value.FOUR;
    private static final Value CALL_ERROR_FUNCTION = Value.FIVE;
    private static final int NO_GOTO = 0;
    private static final int GOTO_LOOP = 1;
    private static final int GOTO_REDUCE = 2;
    private static final int GOTO_TESTSHIFT = 3;
    private static final int GOTO_SHIFT = 4;
    private static final int GOTO_RECOVER = 5;
    private static final int GOTO_SHIFT_RECOVER = 6;
    private static final int GOTO_PUSH = 7;
    private static final int GOTO_SEMANTIC_ACTION = 8;

    private Parsing() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Parsing.parse_tables", "Parsing.parse_env", "Parsing.parser_input", "Obj.t"}, returnType="Parsing.parser_output")
    public static Value caml_parse_engine(Value value, Value value2, Value value3, Value value4) {
        Context context = CurrentContext.CONTEXT;
        PrintStream printStream = context.getCodeState().isParserTraceEnabled() ? new PrintStream(context.getFilesState().getChannel(2).newOutputStream()) : null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        switch (value3.asCastedInt()) {
            case 0: {
                n = 0;
                n2 = value2.get(13L).asCastedInt();
                n4 = 0;
                n10 = 1;
                break;
            }
            case 1: {
                n2 = value2.get(13L).asCastedInt();
                n = value2.get(14L).asCastedInt();
                n4 = value2.get(15L).asCastedInt();
                if (value4.isBlock()) {
                    value2.set(6L, value.get(2L).get(value4.getTag()));
                    value2.set(7L, value4.get0());
                } else {
                    value2.set(6L, value.get(1L).get(value4.asLong()));
                    value2.set(7L, Value.ZERO);
                }
                if (printStream != null) {
                    Parsing.printToken(printStream, value, n, value4);
                }
                n10 = 3;
                break;
            }
            case 5: {
                n2 = value2.get(13L).asCastedInt();
                n = value2.get(14L).asCastedInt();
                n4 = value2.get(15L).asCastedInt();
                n10 = 5;
                break;
            }
            case 2: {
                n2 = value2.get(13L).asCastedInt();
                n = value2.get(14L).asCastedInt();
                n4 = value2.get(15L).asCastedInt();
                n10 = 7;
                break;
            }
            case 3: {
                n2 = value2.get(13L).asCastedInt();
                n = value2.get(14L).asCastedInt();
                n4 = value2.get(15L).asCastedInt();
                n10 = 8;
                break;
            }
            case 4: {
                n2 = value2.get(13L).asCastedInt();
                n = value2.get(14L).asCastedInt();
                n4 = value2.get(15L).asCastedInt();
                value2.get(0L).set(n2, Value.createLong(n));
                value2.get(1L).set(n2, value4);
                n3 = value2.get(10L).asCastedInt();
                value2.get(3L).set(n2, value2.get(3L).get(n3));
                if (n2 > n3) {
                    value2.get(2L).set(n2, value2.get(3L).get(n3));
                }
                n10 = 1;
                break;
            }
            default: {
                assert (false) : "invalid command";
                return RAISE_PARSE_ERROR;
            }
        }
        block18: while (true) {
            switch (n10) {
                case 1: {
                    n5 = Lexing.getShort(value.get(5L), n);
                    if (n5 != 0) {
                        n10 = 2;
                        continue block18;
                    }
                    if (value2.get(6L).asCastedInt() < 0) {
                        value2.set(13L, Value.createLong(n2));
                        value2.set(14L, Value.createLong(n));
                        value2.set(15L, Value.createLong(n4));
                        return READ_TOKEN;
                    }
                    n10 = 3;
                    continue block18;
                }
                case 2: {
                    if (printStream != null) {
                        printStream.printf("State %d: reduce by rule %d\n", n, n5);
                    }
                    n8 = Lexing.getShort(value.get(4L), n5);
                    value2.set(10L, Value.createLong(n2));
                    value2.set(12L, Value.createLong(n5));
                    value2.set(11L, Value.createLong(n8));
                    n2 = n2 - n8 + 1;
                    n8 = Lexing.getShort(value.get(3L), n5);
                    n9 = value2.get(0L).get(n2 - 1).asCastedInt();
                    n6 = Lexing.getShort(value.get(9L), n8);
                    n7 = n6 + n9;
                    n = n6 != 0 && n7 >= 0 && n7 <= value.get(10L).asCastedInt() && Lexing.getShort(value.get(12L), n7) == n9 ? Lexing.getShort(value.get(11L), n7) : Lexing.getShort(value.get(6L), n8);
                    if (n2 >= value2.get(4L).asCastedInt()) {
                        value2.set(13L, Value.createLong(n2));
                        value2.set(14L, Value.createLong(n));
                        value2.set(15L, Value.createLong(n4));
                        return GROW_STACKS_2;
                    }
                    n10 = 8;
                    continue block18;
                }
                case 3: {
                    n6 = Lexing.getShort(value.get(7L), n);
                    n7 = n6 + value2.get(6L).asCastedInt();
                    if (n6 != 0 && n7 >= 0 && (long)n7 <= value.get(10L).asLong() && (long)Lexing.getShort(value.get(12L), n7) == value2.get(6L).asLong()) {
                        n10 = 4;
                        continue block18;
                    }
                    n6 = Lexing.getShort(value.get(8L), n);
                    n7 = n6 + value2.get(6L).asCastedInt();
                    if (n6 != 0 && n7 >= 0 && n7 <= value.get(10L).asCastedInt() && (long)Lexing.getShort(value.get(12L), n7) == value2.get(6L).asLong()) {
                        n5 = Lexing.getShort(value.get(11L), n7);
                        n10 = 2;
                        continue block18;
                    }
                    if (n4 <= 0) {
                        value2.set(13L, Value.createLong(n2));
                        value2.set(14L, Value.createLong(n));
                        value2.set(15L, Value.createLong(n4));
                        return CALL_ERROR_FUNCTION;
                    }
                    n10 = 5;
                    continue block18;
                }
                case 4: {
                    value2.set(6L, Value.MINUS_ONE);
                    if (n4 > 0) {
                        --n4;
                    }
                    n10 = 6;
                    continue block18;
                }
                case 5: {
                    if (n4 < 3) {
                        n4 = 3;
                        break;
                    }
                    if (value2.get(6L).asCastedInt() == 0) {
                        return RAISE_PARSE_ERROR;
                    }
                    if (printStream != null) {
                        printStream.printf("Discarding last token read\n", new Object[0]);
                    }
                    value2.set(6L, Value.MINUS_ONE);
                    n10 = 1;
                    continue block18;
                }
                case 6: {
                    if (printStream != null) {
                        printStream.printf("State %d: shift to state %d\n", n, Lexing.getShort(value.get(11L), n7));
                    }
                    n = Lexing.getShort(value.get(11L), n7);
                    if (++n2 >= value2.get(4L).asCastedInt()) {
                        value2.set(13L, Value.createLong(n2));
                        value2.set(14L, Value.createLong(n));
                        value2.set(15L, Value.createLong(n4));
                        return GROW_STACKS_1;
                    }
                    n10 = 7;
                    continue block18;
                }
                case 7: {
                    value2.get(0L).set(n2, Value.createLong(n));
                    value2.get(1L).set(n2, value2.get(7L));
                    value2.get(2L).set(n2, value2.get(8L));
                    value2.get(3L).set(n2, value2.get(9L));
                    n10 = 1;
                    continue block18;
                }
                case 8: {
                    value2.set(13L, Value.createLong(n2));
                    value2.set(14L, Value.createLong(n));
                    value2.set(15L, Value.createLong(n4));
                    return COMPUTE_SEMANTIC_ACTION;
                }
                default: {
                    assert (false) : "invalid goto";
                    return RAISE_PARSE_ERROR;
                }
            }
            while (true) {
                n9 = value2.get(0L).get(n2).asCastedInt();
                n6 = Lexing.getShort(value.get(7L), n9);
                n7 = n6 + 256;
                if (n6 != 0 && n7 >= 0 && n7 <= value.get(10L).asCastedInt() && Lexing.getShort(value.get(12L), n7) == 256) {
                    if (printStream != null) {
                        printStream.printf("Recovering in state %d\n", n9);
                    }
                    n10 = 6;
                    n10 = 4;
                    continue block18;
                }
                if (printStream != null) {
                    printStream.printf("Discarding state %d\n", n9);
                }
                if (n2 <= value2.get(5L).asCastedInt()) {
                    if (printStream != null) {
                        printStream.printf("No more states to discard\n", new Object[0]);
                    }
                    return RAISE_PARSE_ERROR;
                }
                --n2;
            }
            break;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="bool")
    public static Value caml_set_parser_trace(Value value) {
        CodeState codeState = CurrentContext.CODE_STATE;
        Value value2 = codeState.isParserTraceEnabled() ? Value.TRUE : Value.FALSE;
        codeState.setParserTrace(value != Value.FALSE);
        return value2;
    }

    private static void printToken(PrintStream printStream, Value value, int n, Value value2) {
        if (value2.isLong()) {
            printStream.printf("State %d: read token %s\n", n, Parsing.getTokenName(value.get(14L), value2.asCastedInt()));
        } else {
            printStream.printf("State %d: read token %s(", n, Parsing.getTokenName(value.get(15L), value2.getTag()));
            Value value3 = value2.get0();
            if (value3.isLong()) {
                printStream.printf("%d", value3.asLong());
            } else {
                switch (value3.getTag()) {
                    case 252: {
                        printStream.print(value3.asString());
                        break;
                    }
                    case 253: {
                        boolean bl;
                        StringBuilder stringBuilder = new StringBuilder();
                        Formatter formatter = new Formatter(stringBuilder, Locale.US);
                        formatter.format("%g", value3.asDouble());
                        boolean bl2 = bl = stringBuilder.indexOf("e") >= 0 || stringBuilder.indexOf("E") >= 0;
                        if (!bl) {
                            while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                            }
                        }
                        if (stringBuilder.charAt(stringBuilder.length() - 1) == '.') {
                            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                        }
                        printStream.print(stringBuilder.toString());
                        break;
                    }
                    default: {
                        printStream.print("_");
                    }
                }
            }
            printStream.printf(")\n", new Object[0]);
        }
    }

    private static String getTokenName(Value value, int n) {
        int n2;
        byte[] byArray = value.getBytes();
        int n3 = byArray.length;
        int n4 = 0;
        int n5 = n2 = n <= 0 ? 0 : n;
        if (n2 == 0) {
            int n6;
            for (n6 = 1; n6 < n3 && byArray[n6] != 0; ++n6) {
            }
            return EncodingUtils.convertBytesToString(Arrays.copyOfRange(byArray, 0, n6));
        }
        for (int i = 0; i < n3; ++i) {
            int n7;
            if (byArray[i] != 0 || n2 != ++n4) continue;
            for (n7 = i + 1; n7 < n3 && byArray[n7] != 0; ++n7) {
            }
            return EncodingUtils.convertBytesToString(Arrays.copyOfRange(byArray, i + 1, n7));
        }
        return "<unknown token>";
    }
}

