/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/getpeername.c")
public final class Getpeername {
    private Getpeername() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="Unix.sockaddr")
    public static Value unix_getpeername(Value value) throws Fail.Exception {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("getpeername", "invalid descriptor");
            return Value.UNIT;
        }
        SocketChannel socketChannel = channel.asSocket();
        DatagramChannel datagramChannel = channel.asDatagramSocket();
        try {
            if (socketChannel != null) {
                return Unix.createSockAddr((InetSocketAddress)socketChannel.getRemoteAddress());
            }
            if (datagramChannel != null) {
                return Unix.createSockAddr((InetSocketAddress)datagramChannel.getRemoteAddress());
            }
            Unix.fail("getpeername", "invalid descriptor");
            return Value.UNIT;
        }
        catch (IOException iOException) {
            Unix.fail("getpeername", iOException);
            return Value.UNIT;
        }
    }
}

