/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitArrayTask;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitListTask;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitTask;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ForkJoin", source="")
public final class ForkJoin {
    private ForkJoin() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> ('a * 'a) option)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split(Value pool, Value fork, Value join, Value func, Value x) throws Fail.Exception {
        ForkJoinPool p = (ForkJoinPool)pool.asCustom();
        ForkJoinSplitTask t = new ForkJoinSplitTask(fork, join, func, x);
        Value res = null;
        try {
            res = p.invoke(t);
        }
        catch (RejectedExecutionException ree) {
            Fail.invalidArgument("Concurrent.ForkJoin.split");
        }
        catch (Throwable th) {
            Throwable cause = th.getCause();
            ForkJoin.raiseException(cause, "Concurrent.ForkJoin.split");
        }
        if (res != null) {
            return res;
        }
        ForkJoin.raiseException(t.getException(), "Concurrent.ForkJoin.split");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> 'a list)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split_list(Value pool, Value fork, Value join, Value func, Value x) throws Fail.Exception {
        ForkJoinPool p = (ForkJoinPool)pool.asCustom();
        ForkJoinSplitListTask t = new ForkJoinSplitListTask(fork, join, func, x);
        Value res = null;
        try {
            res = p.invoke(t);
        }
        catch (RejectedExecutionException ree) {
            Fail.invalidArgument("Concurrent.ForkJoin.split_list");
        }
        catch (Throwable th) {
            Throwable cause = th.getCause();
            ForkJoin.raiseException(cause, "Concurrent.ForkJoin.split_list");
        }
        if (res != null) {
            return res;
        }
        ForkJoin.raiseException(t.getException(), "Concurrent.ForkJoin.split_list");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> 'a array)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split_array(Value pool, Value fork, Value join, Value func, Value x) throws Fail.Exception {
        ForkJoinPool p = (ForkJoinPool)pool.asCustom();
        ForkJoinSplitArrayTask t = new ForkJoinSplitArrayTask(fork, join, func, x);
        Value res = null;
        try {
            res = p.invoke(t);
        }
        catch (RejectedExecutionException ree) {
            Fail.invalidArgument("Concurrent.ForkJoin.split_array");
        }
        catch (Throwable th) {
            Throwable cause = th.getCause();
            ForkJoin.raiseException(cause, "Concurrent.ForkJoin.split_array");
        }
        if (res != null) {
            return res;
        }
        ForkJoin.raiseException(t.getException(), "Concurrent.ForkJoin.split_array");
        return Value.UNIT;
    }

    private static void raiseException(Throwable exn, String primitive) throws Fail.Exception {
        Throwable e;
        Throwable throwable = e = exn instanceof RuntimeException ? exn.getCause() : exn;
        if (e instanceof Fail.Exception) {
            Runtime.raiseRaised((Fail.Exception)e);
        } else {
            Fail.failWith(primitive);
        }
    }
}

