(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Access to archives (zip, jar, etc.) in read mode.

    This definition is independent of the actual implementation, that can
    be based on either the OCaml standard library, or the OCaml-Java
    runtime library. *)


type t
(** The type of archive entries. *)

val get_filename : t -> UTF8.t
(** Returns the name of the passed entry inside the archive. *)

val is_directory : t -> bool
(** Tests whether the passed entry designates a directory. *)

val get_extra : t -> Bytes.t
(** Returns the extra data associated with the passed entry. *)

val get_comment : t -> UTF8.t
(** Returns the comment associated with the passed entry. *)
