(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)


let names = [ @"graph" ]

let description = @"prints the graph of jar files"

let latex_description = [
  @"Prints onto the standard output the graph of the passed archives." ;
  @"The graph shows the relationships between the different classes."
]

class parameters = object (self)

  inherit Command.graph_format as super

  val mutable archives = []

  method add_archive a =
    archives <- a :: archives

  method get_archives =
    List.rev archives

  method! switches =
    super#switches

  method! others =
    let open UArg in
    Some { argument_desc = @"arguments are jar files";
           handle_argument = (fun str -> self#add_archive str);  }

end

let make_parameters, switches_of_parameters, others_of_parameters =
  Command.parameters_functions
    (fun () ->
      new parameters)

let run params =
  GraphPrinter.print params#get_graph_format params#get_archives
