/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Marshal", source="byterun/intern.c")
public final class Intern {
    private Intern() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="'a")
    public static Value caml_input_value(Value channel) throws FailException, FatalError, FalseExit {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        DataInputStream in = new DataInputStream(((Channel)channel.asCustom()).newInputStream());
        try {
            return MarshalIntern.inputVal(runner.getContext(), in, true);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(runner.getContext());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="'a")
    public static Value caml_input_value_from_string(Value s, Value offset) throws FailException, FatalError, FalseExit {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        byte[] b = s.getBytes();
        int ofs = offset.asCastedInt();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b, ofs, b.length - ofs));
        try {
            return MarshalIntern.inputVal(runner.getContext(), in, true);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(runner.getContext());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="int")
    public static Value caml_marshal_data_size(Value buff, Value offset) throws FailException, FatalError, FalseExit {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        byte[] b = buff.getBytes();
        int ofs = offset.asCastedInt();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b, ofs, b.length - ofs));
        try {
            if (IO.read32s(in) != -2070567234) {
                Fail.failWith("Marshal.data_size: bad object");
            }
            return Value.createLong(IO.read32u(in));
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(runner.getContext());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
            return Value.UNIT;
        }
    }
}

