/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.values.Value;

public final class DirectoryContents {
    private DirectoryContents() {
    }

    private static List<String> get(FilesState fs, Value path) throws Exception {
        try {
            URL url = fs.getURLForPath(path);
            if ("jar".equals(url.getProtocol())) {
                String entryFile;
                String file = url.getFile();
                int idx = file.indexOf(33);
                String jarFile = file.substring("file:".length(), idx);
                JarFile jar = new JarFile(jarFile);
                JarEntry jarEntry = jar.getJarEntry(entryFile = file.substring(idx + 1));
                if (!jarEntry.isDirectory()) {
                    throw new Exception("Not a directory");
                }
                Enumeration<JarEntry> entries = jar.entries();
                LinkedList<String> resList = new LinkedList<String>();
                while (entries.hasMoreElements()) {
                    String toAdd;
                    JarEntry je = entries.nextElement();
                    String name = "/" + je.getName();
                    if (!name.startsWith(entryFile) || name.equals(entryFile) || name.indexOf(47, entryFile.length() + 1) != -1 || (toAdd = name.substring(entryFile.length() + 1)).length() <= 0) continue;
                    resList.add(toAdd);
                }
                return resList;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static Value getAsValue(FilesState fs, Value path) throws Exception {
        List<String> resList = DirectoryContents.get(fs, path);
        if (resList != null) {
            int len = resList.size();
            Value res = Value.createBlock(0, len);
            for (int i = 0; i < len; ++i) {
                res.set(i, Value.createString(resList.get(i)));
            }
            return res;
        }
        return null;
    }

    public static String[] getAsArray(FilesState fs, Value path) throws Exception {
        List<String> resList = DirectoryContents.get(fs, path);
        if (resList != null) {
            int len = resList.size();
            String[] res = new String[len];
            return resList.toArray(res);
        }
        return null;
    }
}

