/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public abstract class GlobalValue
extends BlockValue {
    protected long header;

    public GlobalValue(int tag, long wosize) {
        this.header = BlockValue.makeHeader(tag, wosize);
    }

    @Override
    public final void set(Value x, long idx) {
        this.set(idx, x);
    }

    @Override
    public final void copyValuesIntoArray(Value[] arr) {
        this.copyValuesIntoArray(arr, 0);
    }

    @Override
    public final Value subArray(long ofs, long len) {
        Value res = Value.createBlock(0, len);
        for (long i = 0L; i < len; ++i) {
            res.set(i, this.get(i));
        }
        return res;
    }

    @Override
    public final void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        }
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws FatalError {
        return -1;
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long v) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public final long getWoSize() {
        return GlobalValue.wosizeFromHeader(this.header);
    }

    @Override
    public long sizeValues() {
        return GlobalValue.wosizeFromHeader(this.header);
    }

    @Override
    public final long getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(long hd) {
        this.header = hd;
    }

    @Override
    public final int getTag() {
        return GlobalValue.tagFromHeader(this.header);
    }

    @Override
    public final void setTag(int t) {
        this.setHeader(GlobalValue.makeHeader(t, this.getWoSize()));
    }
}

