/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.concurrent.atomic.AtomicLong;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

public abstract class BlockValue
extends Value {
    public static final int TAG_CONS = 0;
    public static final long MAX_WOSIZE = 0x3FFFFFFFFFFFFFL;
    public static final int NUM_TAGS = 256;
    public static final int NO_SCAN_TAG = 251;
    public static final int FORWARD_TAG = 250;
    public static final int INFIX_TAG = 249;
    public static final int OBJECT_TAG = 248;
    public static final int CLOSURE_TAG = 247;
    public static final int LAZY_TAG = 246;
    public static final int ABSTRACT_TAG = 251;
    public static final int STRING_TAG = 252;
    public static final int DOUBLE_TAG = 253;
    public static final int DOUBLE_ARRAY_TAG = 254;
    public static final int CUSTOM_TAG = 255;
    public static final long DOUBLE_SIZE = 1L;
    static final long RAW = -1L;
    static final long LONG_OR_OFFSET = -1L;
    private static final AtomicLong NEXT_MAGIC_NUMBER = new AtomicLong();
    private long magicNumber = -1L;

    BlockValue() {
    }

    @Override
    public final boolean isLong() {
        return false;
    }

    @Override
    public final boolean isCodeOffset() {
        return false;
    }

    @Override
    public boolean isMethodHandle() {
        return false;
    }

    @Override
    public final boolean isBlock() {
        return true;
    }

    @Override
    public boolean isDoubleArray() {
        return false;
    }

    @Override
    public boolean isLongBlock() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public final BlockValue asBlock() {
        return this;
    }

    @Override
    public final long asLong() {
        return -1L;
    }

    @Override
    public final long asCodeOffset() {
        return -1L;
    }

    @Override
    public final long getRawValue() {
        return -1L;
    }

    static long makeHeader(int tag, long wosize) {
        assert (wosize >= 0L && wosize <= 0x3FFFFFFFFFFFFFL) : "invalid wosize";
        assert (tag >= 0 && tag <= 255) : "invalid tag";
        return (wosize << 10) + (long)tag;
    }

    public static int tagFromHeader(long hd) {
        return (int)(hd & 0xFFL);
    }

    public static long wosizeFromHeader(long hd) {
        return hd >> 10;
    }

    public abstract void setHeader(long var1);

    @Override
    public final synchronized long getMagicNumber() {
        if (this.magicNumber == -1L) {
            this.magicNumber = NEXT_MAGIC_NUMBER.getAndIncrement();
        }
        return this.magicNumber;
    }

    @Override
    public final Value offset(long ofs) {
        if (this.getTag() == 247 || this.getTag() == 248) {
            return this.get(ofs);
        }
        if (this.getTag() == 249) {
            long i;
            BlockValue parent = this.getParent();
            long len = parent.sizeValues();
            for (i = 0L; !(i >= len || parent.get(i).isBlock() && this == parent.get(i)); ++i) {
            }
            long idx = i + ofs;
            if (idx == 0L) {
                return parent;
            }
            return parent.get(idx);
        }
        assert (false) : "invalid block for offset";
        return null;
    }

    public final void truncate(long size) throws FailException {
        long newSize;
        long oldSize = this.getWoSize();
        int oldTag = this.getTag();
        long l = newSize = oldTag == 253 ? size * 1L : size;
        if (newSize <= 0L || newSize > oldSize) {
            Fail.invalidArgument("Obj.truncate");
        }
        if (newSize != oldSize) {
            this.setHeader(BlockValue.makeHeader(oldTag, newSize));
            this.truncateInstance(newSize);
        }
    }

    @Override
    public final int switchTag() {
        return -this.getTag() - 1;
    }

    protected abstract void truncateInstance(long var1);

    public abstract void copy(BlockValue var1);
}

