/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.ocamljava.runtime.util.MemoryInputStream;

public final class RandomAccessInputStream {
    private static final String FILE_MODE_READ = "r";
    private static final int BUFFER_SIZE = 65536;
    private final byte[] bytes;
    private final RandomAccessFile file;

    public RandomAccessInputStream(File f) throws FileNotFoundException {
        assert (f != null) : "null f";
        this.file = new RandomAccessFile(f, FILE_MODE_READ);
        this.bytes = null;
    }

    public RandomAccessInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    public RandomAccessInputStream(InputStream in, int maxSize) throws IOException {
        assert (in != null) : "null in";
        assert (maxSize >= 0) : "maxSize should be >= 0";
        if (maxSize == 0) {
            this.bytes = new byte[0];
        } else {
            byte[] buffer = new byte[65536];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int nb = in.read(buffer);
            for (int size = 0; nb != -1 && size < maxSize; size += nb) {
                baos.write(buffer, 0, nb);
                nb = in.read(buffer);
            }
            this.bytes = baos.toByteArray();
        }
        this.file = null;
    }

    public RandomAccessInputStream(InputStream in) throws IOException {
        this(in, Integer.MAX_VALUE);
    }

    public DataInput dataInputFrom(long ofs) throws IOException {
        assert (ofs >= 0L) : "ofs should be >= 0";
        if (this.file != null) {
            this.file.seek(ofs);
            return this.file;
        }
        assert (ofs <= Integer.MAX_VALUE) : "ofs should be <= Integer.MAX_VALUE when in 'stream' mode";
        int offset = (int)ofs;
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes, offset, this.bytes.length - offset);
        return new DataInputStream(bais);
    }

    public byte[] readBytes(long ofs, int len) throws IOException {
        assert (ofs >= 0L) : "ofs should be >= 0";
        assert (len >= 0) : "len should be >= 0";
        byte[] res = new byte[len];
        if (this.file != null) {
            this.file.seek(ofs);
            this.file.readFully(res);
        } else {
            assert (ofs <= Integer.MAX_VALUE) : "ofs should be <= Integer.MAX_VALUE when in 'stream' mode";
            try {
                System.arraycopy(this.bytes, (int)ofs, res, 0, len);
            }
            catch (IndexOutOfBoundsException x) {
                throw new IOException(x.toString());
            }
        }
        return res;
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public long length() throws IOException {
        if (this.file != null) {
            return this.file.length();
        }
        return this.bytes.length;
    }

    public MemoryInputStream createInputStream() {
        if (this.bytes != null) {
            return new MemoryInputStream(this.bytes);
        }
        return null;
    }
}

