#
#  Copyright (c) 2005 Advanced Micro Devices, Inc.
#
#  See the file "license.amd" for information on usage and
#  redistribution of this file, and for a DISCLAIMER OF ALL
#   WARRANTIES.
#
#  RCS: @(#) $Id: descend.tcl,v 1.4 2006/05/29 21:56:14 mdejong Exp $
#
#

# The descend module will parse a Tcl script and invoke
# built-in Tcl command specific methods that will
# descend into the structure of commands.

# Init descend module

TJC::command descend_init tjc.DescendInitCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return the next parse key that is available.
# This module passes a parse key around so that
# functions can access parse information found
# when a specific command was parsed from a
# script.

TJC::command descend_next_key tjc.DescendNextKeyCmd
#
#
#
#
#

# Start parsing the given script, this method will
# return a list of keys that were parsed as the
# script was descended into.

TJC::command descend_start tjc.DescendStartCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Parse the next command from the given script
# and create a new key for the parse result.

TJC::command descend_next_command tjc.DescendNextCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked each time a command is parsed from
# a script passed to descend_start. This
# method will invoke a user defined callback
# so that user code can record that a specific
# command was discovered.

TJC::command descend_report_command tjc.DescendReportCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Like descend_report_command except that this callback is
# invoked after a command and any contained commands have
# been processed.

TJC::command descend_report_command_finish tjc.DescendReportCommandFinishCmd
#
#
#
#
#
#
#
#
#
#
#
#
#


# Define a callback command that will be invoked
# each time a command is parsed from the script.
# The callback should accept one argument, the
# parse key for this specific command.

TJC::command descend_report_command_callback tjc.DescendReportCommandCallbackCmd
#
#
#
#
#
#
#
#
#

# Report command keys as they appear in the body of the script
# passed to descend_start. When no key is given, the keys
# detected in the topmost layer of the script passed to descend_start
# are returned. Otherwise, a list of keys that corresponds to
# the command arguments for a given key are returned. The default
# type argument will return "nested" type command invocations. If
# the "container" type is passed, container commands will be
# returned instead.

TJC::command descend_commands tjc.DescendCommandsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Push a new empty list of commands onto the body stack. This
# list is filled as nested commands are discovered. 

TJC::command _descend_commands_push tjc.DescendCommandsPushCmd
#
#
#
#
#
#

# Pop the current list of commands off the body stack. This
# is used to report the commands that have been found at
# a given level while descending into a script.

TJC::command _descend_commands_pop tjc.DescendCommandsPopCmd
#
#
#
#
#

# Add a parsed command key to the list of commands at
# the top of the body stack.

TJC::command _descend_commands_add tjc.DescendCommandsAddCmd
#
#
#
#
#
#

# Invoked when a usage error is found while
# descending into a command.

TJC::command descend_report_usage tjc.DescendReportUsageCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

# Define a callback command that will be invoked
# each time a usage error is found while descending
# into a script.

TJC::command descend_report_usage_callback tjc.DescendReportUsageCallbackCmd
#
#
#

# Get data element for the named key. This command
# is invoked frequently, so it is as optimized.

TJC::command descend_get_data tjc.DescendGetDataCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if a script argument to a container command
# is statically defined. For example the command [if {1} {cmd1}]
# has a statically defined script argument at index 2. The
# same would also apply to [if {1} cmd1], while [if {1} $script]
# and [if {1} [command]] would not be considered static.

TJC::command descend_container_argument_body_is_static tjc.DescendContainerArgumentBodyIsStaticCmd
#
#
#
#
#
#
#
#

# Return true if arguments for the given command could not
# be determined. There are cases where a command would be
# invoked at runtime, but it is not possible to tell what
# the arguments to the command would be.

TJC::command descend_arguments_undetermined tjc.DescendArgumentsUndeterminedCmd
#
#
#

# Return a pair {result cmdname}. If the command name
# can not be determined statically, then {0 {}} will
# be returned. Otherwise, {1 cmdname} will be returned.

TJC::command descend_get_command_name tjc.DescendGetCommandNameCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return a list consisting of the command and its arguments.
# If the arguments could not be determined, then only the
# command name is returned.

TJC::command descend_get_command tjc.DescendGetCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command descend_tree_get_command tjc.DescendTreeGetCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return a command element as a list element. This
# can include the command name or one of its arguments.

TJC::command descend_tree_get tjc.DescendTreeGetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# This command will loop over the command word and
# any arguments checking for a nested command invocations.

TJC::command descend_check_nested_commands tjc.DescendCheckNestedCommandsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked when a variable subtree should be checked to see if it contains
# command invocations.

TJC::command descend_check_variable_for_nested_commands tjc.DescendCheckVariableForNestedCommandsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Callback invoked from descend_check_nested_commands while
# descending into the elements in a variable looking for
# command elements.

TJC::command descend_check_variable_for_nested_commands_iterator tjc.DescendCheckVariableForNestedCommandsIteratorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked when a word subtree should be checked to see if any
# of the word elements are command invocations.

TJC::command descend_check_word_for_nested_commands tjc.DescendCheckWordForNestedCommandsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

# Callback invoked from descend_check_word_for_nested_commands while
# descending into the elements in a word looking for
# command elements.

TJC::command descend_check_word_for_nested_commands_iterator tjc.DescendCheckWordForNestedCommandsIteratorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Check the given parsed command to see if it is a "container"
# command that contains other code to evaulate. For example,
# the if command is a container command.

TJC::command descend_check_container_command tjc.DescendCheckContainerCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return "container" stack, this is a stack of command names that contain
# other commands. For example, an if command contains code in a true block.
# The commands inside the true block are considered to be in the "if" container.

TJC::command descend_get_container_stack tjc.DescendGetContainerStackCmd
#
#
#

# Debug command that will print the contents of a parse tree.

TJC::command descend_tree_print tjc.DescendTreePrintCmd
#
#
#
#

TJC::command _descend_tree_print tjc.DescendTreePrintCmd2
#
#
#
#
#
#
#
#
#
#
#
#

# Return the range of the unquoted body given a body
# argument that may or may not be quoted. If it is
# not quoted, then range return is the one passed in.

TJC::command descend_range_quoted tjc.DescendRangeQuotedCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Like descend_range_quoted except for a bracketed nested command

TJC::command descend_range_bracked tjc.DescendRangeBrackedCmd
#
#

# Descend into a script containing commands that are passed as
# a body argument. For example an if command like "if {1} { cmd1 }"
# has a container body argument "{ cmd 1 }". This procedure returns
# a list of keys parsed.

TJC::command descend_container_body_argument tjc.DescendContainerBodyArgumentCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Descend into a script that is made up of multiple arguments
# concatenated together. For example an after command like
# after 50 cmd {arg1 arg2} arg3 should descend into the equivalent
# of {cmd arg1 arg2 arg3}. The most common case is
# after 50 "cmd arg1 arg2 arg3" which should be descended
# into as [cmd arg1 arg2 arg3]. This procedure returns
# a list of keys parsed.

TJC::command descend_container_concat_body_arguments tjc.DescendContainerConcatBodyArgumentsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Descend into a nested command enclosed in brackets.
# For example a command like "set var [one]" would
# descend into the "[one]" arguments minus the brackets.
# This procedure returns a list of keys parsed.

TJC::command descend_nested_subtree tjc.DescendNestedSubtreeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Generate an empty nested command key and
# report it in the normal way.

TJC::command descend_empty_nested_command tjc.DescendEmptyNestedCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked when an if command is discovered while descending into a
# Tcl script.

TJC::command descend_container_if tjc.DescendContainerIfCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "if" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.

TJC::command descend_container_if_validate tjc.DescendContainerIfValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# The container functions below (like descend_container_if_expr)
# assume that the arguments to the function have already been
# validated (with descend_container_if_validate for example).

# Return {EXPR_INDEX BODY_INDEX} for if command.

TJC::command descend_container_if_expr_body tjc.DescendContainerIfExprBodyCmd
#
#
#
#

# Return true if there are one of more "elseif EXPR BODY" arguments
# for this if command.

TJC::command descend_container_if_has_elseif_body tjc.DescendContainerIfHasElseifBodyCmd
#
#
#
#

# Return a list of {EXPR_INDEX BODY_INDEX} elements
# for each elseif block.

TJC::command descend_container_if_iterate_elseif_body tjc.DescendContainerIfIterateElseifBodyCmd
#
#
#
#
#
#
#
#

# Return true if this "if" command has an "else BODY" block.

TJC::command descend_container_if_has_else_body tjc.DescendContainerIfHasElseBodyCmd
#
#
#
#

# Return the BODY_INDEX for the "else BODY" block of this if command.

TJC::command descend_container_if_else_body tjc.DescendContainerIfElseBodyCmd
#
#
#
#
#
#
#
#
#
#
#

# Invoked when a catch command is discovered while descending into a
# Tcl script.

TJC::command descend_container_catch tjc.DescendContainerCatchCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "catch" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.

TJC::command descend_container_catch_validate tjc.DescendContainerCatchValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return BODY_INDEX for catch command.

TJC::command descend_container_catch_body tjc.DescendContainerCatchBodyCmd
#
#
#
#

# Return true if there is a variable name argument
# for the catch command.

TJC::command descend_container_catch_has_variable tjc.DescendContainerCatchHasVariableCmd
#
#
#
#
#
#
#
#
#

# If the catch variable is statically defined,
# return {1 VARNAME} indicating the name. Otherwise
# return {0 {}} to indicate that the variable
# name needs to be evaluated at runtime.

TJC::command descend_container_catch_variable tjc.DescendContainerCatchVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked when a while command is discovered while descending into a
# Tcl script.

TJC::command descend_container_while tjc.DescendContainerWhileCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "while" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.

TJC::command descend_container_while_validate tjc.DescendContainerWhileValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return EXPR_INDEX for while command.

TJC::command descend_container_while_expr tjc.DescendContainerWhileExprCmd
#
#
#
#

# Return BODY_INDEX for while command

TJC::command descend_container_while_body tjc.DescendContainerWhileBodyCmd
#
#
#
#

# Invoked when a for command is discovered while descending into a
# Tcl script.

TJC::command descend_container_for tjc.DescendContainerForCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "for" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.

TJC::command descend_container_for_validate tjc.DescendContainerForValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return BODY_INDEX for the start script argument.

TJC::command descend_container_for_start tjc.DescendContainerForStartCmd
#
#
#
#

# Return EXPR_INDEX for the test expr argument.

TJC::command descend_container_for_expr tjc.DescendContainerForExprCmd
#
#
#
#

# Return BODY_INDEX for the next script argument.

TJC::command descend_container_for_next tjc.DescendContainerForNextCmd
#
#
#
#

# Return BODY_INDEX for the body script argument.

TJC::command descend_container_for_body tjc.DescendContainerForBodyCmd
#
#
#
#


# Invoked when a foreach command is discovered while descending into a
# Tcl script.

TJC::command descend_container_foreach tjc.DescendContainerForeachCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "foreach" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.

TJC::command descend_container_foreach_validate tjc.DescendContainerForeachValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the foreach command iterates over
# a single list.

TJC::command descend_container_foreach_has_single_list tjc.DescendContainerForeachHasSingleListCmd
#
#
#
#
#
#
#
#
#

# Return true if the foreach command iterates over
# a single list with a single variable.

TJC::command descend_container_foreach_has_single_variable tjc.DescendContainerForeachHasSingleVariableCmd
#
#
#
#
#
#
#
#
#

# Return a list of variable names that were passed
# as a varlist option to the foreach command.
# If only a single variable name was given then
# it is returned.

TJC::command descend_container_foreach_varlist tjc.DescendContainerForeachVarlistCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return list of {VARLIST_INDEX VARVALUES_INDEX} arguments.

TJC::command descend_container_foreach_varlistvalues tjc.DescendContainerForeachVarlistvaluesCmd
#
#
#
#

# Return BODY_INDEX for the body script argument

TJC::command descend_container_foreach_body tjc.DescendContainerForeachBodyCmd
#
#
#
#

# Invoked when a switch command is discovered while descending into a
# Tcl script.

TJC::command descend_container_switch tjc.DescendContainerSwitchCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return "" if the string argument is not one of the
# mode arguments (-exact -regexp or -glob). Return
# the full mode string if it is.

TJC::command descend_container_switch_is_switch_mode tjc.DescendContainerSwitchIsSwitchModeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "switch" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.
# This validate command can also rewrite the switch script and
# reparse it, this is the only command that does this.

TJC::command descend_container_switch_validate tjc.DescendContainerSwitchValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Recreate the script containing a switch command
# with a list of pattern/body elements. Elements
# that contain backslashed characters will be
# double quoted. Elements that contains no backslash
# characters will be brace quoted. The generated
# script is returned.

TJC::command descend_container_switch_script_recreate tjc.DescendContainerSwitchScriptRecreateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return the mode of the switch command. If no option argument
# was passed to the switch command, then "default" will be
# returned. Otherwise, "exact", "glob", or "regexp" will be
# returned.

TJC::command descend_container_switch_mode tjc.DescendContainerSwitchModeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the switch command has a "--" token
# that indicates the last argument was given appears
# just before the string argument.

TJC::command descend_container_switch_has_last tjc.DescendContainerSwitchHasLastCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return the index of the string argument to the switch command

TJC::command descend_container_switch_string tjc.DescendContainerSwitchStringCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return list of {PATTERN_INDEX BODY_INDEX} argument indexes.

TJC::command descend_container_switch_patbody_indexes tjc.DescendContainerSwitchPatbodyIndexesCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the switch has a pattern/body list
# before it was reparsed.

TJC::command descend_container_switch_has_patbody_list tjc.DescendContainerSwitchHasPatbodyListCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the body of a pattern/body in a switch command
# is the fall through token "-". This indicates that the
# body from the next switch pattern/body pair should be
# evaluated.

TJC::command descend_container_switch_is_fallthrough tjc.DescendContainerSwitchIsFallthroughCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#



# Invoked when an after command is discovered while descending into a
# Tcl script.

TJC::command descend_container_after tjc.DescendContainerAfterCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "after" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.

TJC::command descend_container_after_validate tjc.DescendContainerAfterValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true for an after command invocation where a command
# to be evaluated later is passed into the after command.

TJC::command descend_container_after_has_command_indexes tjc.DescendContainerAfterHasCommandIndexesCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Get the command argument indexes for an after command where
# descend_container_after_has_command_indexes return true.
# The first index is the command, each additional index
# corresponds to arguments to the command.

TJC::command descend_container_after_command_indexes tjc.DescendContainerAfterCommandIndexesCmd
#
#
#
#
#
#
#
#
#
#
#
#
#



# Invoked when an lsort command is discovered while descending into a
# Tcl script.

TJC::command descend_container_lsort tjc.DescendContainerLsortCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "lsort" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.

TJC::command descend_container_lsort_validate tjc.DescendContainerLsortValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command descend_container_lsort_has_command tjc.DescendContainerLsortHasCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return index of -commmand argument for lsort command

TJC::command descend_container_lsort_command tjc.DescendContainerLsortCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# Descend into expr command looking for commands that should be run.

TJC::command descend_container_expr tjc.DescendContainerExprCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Descend into an expr argument to a command. This method assumes
# that the expr argument has already been validated.

TJC::command descend_container_expr_argument tjc.DescendContainerExprArgumentCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked once for each subexpression inside the expr argument tree.

TJC::command descend_container_expr_argument_iterate_callback tjc.DescendContainerExprArgumentIterateCallbackCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If the "expr" command indicated by "key" has valid arguments,
# then return "OK". If any of the arguments are invalid
# then return an error message indicating the problem.

TJC::command descend_container_expr_validate tjc.DescendContainerExprValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the expr argument at the given index is valid.

TJC::command descend_container_expr_argument_validate tjc.DescendContainerExprArgumentValidateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return EXPR_INDEX for the braced argument passed to
# the expr command.

TJC::command descend_container_expr_arg tjc.DescendContainerExprArgCmd
#
#
#
#

# Return true if the container command indicated by
# key passed the command validation tests. This
# command works for any of the constainer commands.

TJC::command descend_container_is_valid tjc.DescendContainerIsValidCmd
#
#
#
#
#
#

# Return true if the container command identified by
# key is statically defined. This means that each
# body block is a list of commands that does not
# change at runtime. If the command contains
# expr bodies, each must be brace quoted.

TJC::command descend_container_is_static tjc.DescendContainerIsStaticCmd
#
#
#

# Parse a simple variable name into a two part
# name. The variable name "a" would be parsed
# into {scalar a} while the variable name
# "a(b)" would be parsed into {array a b}.

TJC::command descend_simple_variable tjc.DescendSimpleVariableCmd
#
#
#
#
#
#
#

# Tcl commands that act as containers for more code
# this means that they eval a brace quoted string
# of code passed to them.
#
# after (delay)         DONE (needs work)
# case                  UNSUPPORTED
# catch                 DONE
# eval
# expr                  DONE
# fileevent (delay)
# for                   DONE
# foreach               DONE
# if                    DONE
# interp eval
# lsort -command        DONE (needs work)
# namespace eval
# package ifneeded      UNSUPPORTED
# proc                  NOT-CONTAINER
# switch                DONE
# uplevel
# while                 DONE


