/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Weak", source="byterun/weak.c")
public final class Weak {
    private static final Value NONE = Value.ZERO;
    private static final int SOME_TAG = 0;

    private Weak() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="'a Weak.t")
    public static Value caml_weak_create(Value len) throws FailException {
        long sz = len.asLong() + 1L;
        if (sz <= 0L || sz > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Weak.create");
        }
        return Value.createWeakBlock(sz);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int", "'a option"}, returnType="unit")
    public static Value caml_weak_set(Value ar, Value n, Value el) throws FailException {
        long offset = n.asLong() + 1L;
        if (offset < 1L || offset >= ar.sizeWeakValues()) {
            Fail.invalidArgument("Weak.set");
        } else {
            ar.setWeak(offset, null);
            if (el.isBlock()) {
                assert (el.sizeValues() == 1L) : "invalid el";
                ar.setWeak(offset, el.get0());
            }
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int"}, returnType="'a option")
    public static Value caml_weak_get(Value ar, Value n) throws FailException {
        Value elem;
        long offset = n.asLong() + 1L;
        if (offset < 1L || offset >= ar.sizeWeakValues()) {
            Fail.invalidArgument("Weak.get");
        }
        if ((elem = ar.getWeak(offset)) == null) {
            return NONE;
        }
        return Value.createBlock(0, elem);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int"}, returnType="'a option")
    public static Value caml_weak_get_copy(Value ar, Value n) throws FailException {
        Value elem;
        Value v;
        long offset = n.asLong() + 1L;
        if (offset < 1L || offset >= ar.sizeWeakValues()) {
            Fail.invalidArgument("Weak.get");
        }
        if ((v = ar.getWeak(offset)) == null) {
            return NONE;
        }
        if (v.isBlock()) {
            int tag = v.getTag();
            if (tag < 251) {
                long sz = v.sizeValues();
                Value tmp = Value.createBlock(tag, sz);
                for (long i = 0L; i < sz; ++i) {
                    tmp.set(i, v.get(i));
                }
                elem = tmp;
            } else {
                elem = v.duplicate();
            }
        } else {
            elem = v;
        }
        return Value.createBlock(0, elem);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int"}, returnType="bool")
    public static Value caml_weak_check(Value ar, Value n) throws FailException {
        long offset = n.asLong() + 1L;
        if (offset < 1L || offset >= ar.sizeWeakValues()) {
            Fail.invalidArgument("Weak.get");
        }
        return ar.getWeak(offset) != null ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int", "'a Weak.t", "int", "int"}, returnType="unit")
    public static Value caml_weak_blit(Value ars, Value ofs, Value ard, Value ofd, Value len) throws FailException {
        long offsetS = ofs.asLong() + 1L;
        long offsetD = ofd.asLong() + 1L;
        long length = len.asLong();
        if (offsetS < 1L || offsetS + length > ars.sizeWeakValues()) {
            Fail.invalidArgument("Weak.blit");
        }
        if (offsetD < 1L || offsetD + length > ard.sizeWeakValues()) {
            Fail.invalidArgument("Weak.blit");
        }
        if (offsetD < offsetS) {
            for (long i = 0L; i < length; ++i) {
                ard.setWeak(offsetD + i, ars.getWeak(offsetS + i));
            }
        } else {
            for (long i = length - 1L; i >= 0L; --i) {
                ard.setWeak(offsetD + i, ars.getWeak(offsetS + i));
            }
        }
        return Value.UNIT;
    }
}

