/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipFile;
import org.codehaus.janino.util.iterator.MultiDimensionalIterator;
import org.codehaus.janino.util.iterator.TransformingIterator;
import org.codehaus.janino.util.resource.LazyMultiResourceFinder;
import org.codehaus.janino.util.resource.ResourceFinder;
import org.codehaus.janino.util.resource.ZipFileResourceFinder;

public class JarDirectoriesResourceFinder
extends LazyMultiResourceFinder {
    public JarDirectoriesResourceFinder(File[] directories) {
        super(new MultiDimensionalIterator(new TransformingIterator(Arrays.asList(directories).iterator()){

            protected Object transform(Object o) {
                File directory = (File)o;
                File[] jarFiles = directory.listFiles(new FilenameFilter(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                return new TransformingIterator(this, Arrays.asList(jarFiles).iterator()){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected Object transform(Object o) {
                        File zipFile = (File)o;
                        try {
                            return new ZipFileResourceFinder(new ZipFile(zipFile));
                        }
                        catch (IOException e) {
                            return ResourceFinder.EMPTY_RESOURCE_FINDER;
                        }
                    }
                };
            }
        }, 2));
    }
}

