/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.FutureCallable;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ThreadFactory;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ThreadPoolExecutor", source="")
public final class ThreadPoolExecutor {
    private ThreadPoolExecutor() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "int32", "int64", "TimeUnit.t", "RejectedExecutionHandler.t"}, returnType="ThreadPoolExecutor.t")
    public static Value ocamljava_threadpoolexecutor_make(Value value, Value value2, Value value3, Value value4, Value value5) throws FailException {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory = new ThreadFactory(OCamlJavaThread.getCodeRunner());
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = new java.util.concurrent.ThreadPoolExecutor(value.asInt32(), value2.asInt32(), value3.asInt64(), (TimeUnit)((Object)value4.asCustom()), linkedBlockingQueue, threadFactory, (RejectedExecutionHandler)value5.asCustom());
        return Value.createInstance(threadPoolExecutor);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "int32", "int64", "TimeUnit.t", "RejectedExecutionHandler.t"}, returnType="ThreadPoolExecutor.t")
    public static java.util.concurrent.ThreadPoolExecutor ocamljava_threadpoolexecutor_make$(int n, int n2, long l, TimeUnit timeUnit, RejectedExecutionHandler rejectedExecutionHandler) throws FailException {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory = new ThreadFactory(OCamlJavaThread.getCodeRunner());
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = new java.util.concurrent.ThreadPoolExecutor(n, n2, l, timeUnit, linkedBlockingQueue, threadFactory, rejectedExecutionHandler);
        return threadPoolExecutor;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all(Value value, Value value2) throws FailException, Throwable {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value2);
        return ThreadPoolExecutor.encodeFutureList(threadPoolExecutor.invokeAll(list));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all$(java.util.concurrent.ThreadPoolExecutor threadPoolExecutor, Value value) throws FailException, Throwable {
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value);
        return ThreadPoolExecutor.encodeFutureList(threadPoolExecutor.invokeAll(list));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all_time(Value value, Value value2, Value value3, Value value4) throws FailException, Throwable {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value2);
        return ThreadPoolExecutor.encodeFutureList(threadPoolExecutor.invokeAll(list, value3.asInt64(), (TimeUnit)((Object)value4.asCustom())));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all_time$(java.util.concurrent.ThreadPoolExecutor threadPoolExecutor, Value value, long l, TimeUnit timeUnit) throws FailException, Throwable {
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value);
        return ThreadPoolExecutor.encodeFutureList(threadPoolExecutor.invokeAll(list, l, timeUnit));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any(Value value, Value value2) throws FailException, Throwable {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value2);
        return threadPoolExecutor.invokeAny(list);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any$(java.util.concurrent.ThreadPoolExecutor threadPoolExecutor, Value value) throws FailException, Throwable {
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value);
        return threadPoolExecutor.invokeAny(list);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any_time(Value value, Value value2, Value value3, Value value4) throws FailException, Throwable {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value2);
        return threadPoolExecutor.invokeAny(list, value3.asInt64(), (TimeUnit)((Object)value4.asCustom()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any_time$(java.util.concurrent.ThreadPoolExecutor threadPoolExecutor, Value value, long l, TimeUnit timeUnit) throws FailException, Throwable {
        List<Callable<Value>> list = ThreadPoolExecutor.decodeCallableList(value);
        return threadPoolExecutor.invokeAny(list, l, timeUnit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_shutdown_now(Value value) {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return ThreadPoolExecutor.encodeRunnableList(threadPoolExecutor.shutdownNow());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_shutdown_now$(java.util.concurrent.ThreadPoolExecutor threadPoolExecutor) {
        return ThreadPoolExecutor.encodeRunnableList(threadPoolExecutor.shutdownNow());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "('a -> 'b)", "'a"}, returnType="'b Future.t")
    public static Value ocamljava_threadpoolexecutor_submit(Value value, Value value2, Value value3) throws FailException {
        java.util.concurrent.ThreadPoolExecutor threadPoolExecutor = (java.util.concurrent.ThreadPoolExecutor)value.asCustom();
        return Value.createInstance(threadPoolExecutor.submit(new FutureCallable(value2, value3)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "('a -> 'b)", "'a"}, returnType="'b Future.t")
    public static Future<Value> ocamljava_threadpoolexecutor_submit$(java.util.concurrent.ThreadPoolExecutor threadPoolExecutor, Value value, Value value2) throws FailException {
        return threadPoolExecutor.submit(new FutureCallable(value, value2));
    }

    static List<Callable<Value>> decodeCallableList(Value value) {
        LinkedList<Callable<Value>> linkedList = new LinkedList<Callable<Value>>();
        Value value2 = value;
        while (value2.isBlock()) {
            linkedList.add(new FutureCallable(value2.get0(), Value.UNIT));
            value2 = value2.get1();
        }
        return linkedList;
    }

    static Value encodeFutureList(List<Future<Value>> list) {
        Value value = Value.EMPTY_LIST;
        ListIterator<Future<Value>> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            value = Value.createBlock(0, Value.createInstance(listIterator.previous()), value);
        }
        return value;
    }

    static Value encodeRunnableList(List<Runnable> list) {
        Value value = Value.EMPTY_LIST;
        ListIterator<Runnable> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            Runnable runnable = listIterator.previous();
            if (!(runnable instanceof RunnableFuture)) continue;
            value = Value.createBlock(0, Value.createInstance(runnable), value);
        }
        return value;
    }
}

