/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.values.AbstractLongBlockValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class LargeLongBlockValue
extends AbstractLongBlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private long[][] values;

    LargeLongBlockValue(int tag, long sz) {
        super(tag, sz);
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.values = new long[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new long[Integer.MIN_VALUE];
        }
        this.values[len - 1] = new long[lenLast];
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        return this.values[idx1][idx2];
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[0][idx];
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        this.values[idx1][idx2] = x;
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        this.values[0][idx] = x;
    }

    @Override
    public long sizeLongs() {
        return this.length;
    }

    @Override
    public long arrayLength() {
        return this.length;
    }

    @Override
    protected void truncateInstance(long sz) {
        long[][] oldValues = this.values;
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.values = new long[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new long[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.values[i][j] = oldValues[i][j];
            }
        }
        this.values[len - 1] = new long[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.values[len - 1][j] = oldValues[len - 1][j];
        }
    }

    @Override
    public void copy(BlockValue src) {
        long len = Math.min(this.length, src.sizeLongs());
        for (long i = 0L; i < len; ++i) {
            this.setRawLong(i, src.getRawLong(i));
        }
    }

    @Override
    public LargeLongBlockValue duplicate() {
        long len = this.length;
        LargeLongBlockValue res = new LargeLongBlockValue(this.getTag(), len);
        for (long i = 0L; i < len; ++i) {
            res.setRawLong(i, this.getRawLong(i));
        }
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < len; ++i) {
            dest[i] = Value.createFromRawLong(this.getRawLong(i));
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = Value.createFromRawLong(this.getRawLong(i));
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getRawLong(i);
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeLongs());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getRawLong(i);
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        LargeLongBlockValue res = new LargeLongBlockValue(this.getTag(), len);
        for (long i = 0L; i < len; ++i) {
            res.setRawLong(i, this.getRawLong(i + ofs));
        }
        return res;
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setRawLong(destOfs + i, this.getRawLong(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setRawLong(destOfs + i, this.getRawLong(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        long[] v = this.values[0];
        int len = Math.min(32, v.length);
        for (int i = 0; i < len; ++i) {
            res += (int)v[i];
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LargeLongBlockValue) {
            LargeLongBlockValue that = (LargeLongBlockValue)obj;
            int lenThis = this.values.length;
            int lenThat = that.values.length;
            if (lenThis == lenThis) {
                int i;
                for (i = 0; i < lenThis && Arrays.equals(this.values[i], that.values[i]); ++i) {
                }
                return i == lenThis;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LargeLongBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            int l = this.values[i].length;
            for (int j = 0; j < l; ++j) {
                if (i + j != 0) {
                    sb.append(", ");
                }
                sb.append(this.values[i][j]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long v) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws FatalError {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value x, long idx) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.setRawLong(idx, x.getRawValue());
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.setRawLong(idx, x.getRawValue());
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.setRawLong(idx, x.getRawValue());
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        return Value.createFromRawLong(this.getRawLong(idx));
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        return Value.createFromRawLong(this.getRawLong(idx));
    }

    @Override
    public long sizeDoubles() {
        return this.length;
    }

    @Override
    public void setGenericDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        this.setRawLong(idx, (long)x);
    }

    @Override
    public void setGenericDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        this.setRawLong(idx, (long)x);
    }

    @Override
    public double getGenericDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return this.getRawLong(idx);
    }

    @Override
    public double getGenericDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return this.getRawLong(idx);
    }

    @Override
    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        this.setRawLong(idx, (long)x);
    }

    @Override
    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        this.setRawLong(idx, (long)x);
    }

    @Override
    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return this.getRawLong(idx);
    }

    @Override
    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return this.getRawLong(idx);
    }

    @Override
    public void setRawLong0(long x) {
        this.setRawLong(0, x);
    }

    @Override
    public long getRawLong0() {
        return this.getRawLong(0);
    }

    @Override
    public void setGenericDouble0(double x) {
        this.setRawLong(0, (long)x);
    }

    @Override
    public double getGenericDouble0() {
        return this.getRawLong(0);
    }

    @Override
    public void setDouble0(double x) {
        this.setRawLong(0, (long)x);
    }

    @Override
    public double getDouble0() {
        return this.getRawLong(0);
    }

    @Override
    public void set0(Value x) {
        this.setRawLong(0, x.getRawValue());
    }

    @Override
    public Value get0() {
        return Value.createDouble(this.getRawLong(0));
    }

    @Override
    public void setRawLong1(long x) {
        this.setRawLong(1, x);
    }

    @Override
    public long getRawLong1() {
        return this.getRawLong(1);
    }

    @Override
    public void setGenericDouble1(double x) {
        this.setRawLong(1, (long)x);
    }

    @Override
    public double getGenericDouble1() {
        return this.getRawLong(1);
    }

    @Override
    public void setDouble1(double x) {
        this.setRawLong(1, (long)x);
    }

    @Override
    public double getDouble1() {
        return this.getRawLong(1);
    }

    @Override
    public void set1(Value x) {
        this.setRawLong(1, x.getRawValue());
    }

    @Override
    public Value get1() {
        return Value.createDouble(this.getRawLong(1));
    }

    @Override
    public void setRawLong2(long x) {
        this.setRawLong(2, x);
    }

    @Override
    public long getRawLong2() {
        return this.getRawLong(2);
    }

    @Override
    public void setGenericDouble2(double x) {
        this.setRawLong(2, (long)x);
    }

    @Override
    public double getGenericDouble2() {
        return this.getRawLong(2);
    }

    @Override
    public void setDouble2(double x) {
        this.setRawLong(2, (long)x);
    }

    @Override
    public double getDouble2() {
        return this.getRawLong(2);
    }

    @Override
    public void set2(Value x) {
        this.setRawLong(2, x.getRawValue());
    }

    @Override
    public Value get2() {
        return Value.createDouble(this.getRawLong(2));
    }

    @Override
    public void setRawLong3(long x) {
        this.setRawLong(3, x);
    }

    @Override
    public long getRawLong3() {
        return this.getRawLong(3);
    }

    @Override
    public void setGenericDouble3(double x) {
        this.setRawLong(3, (long)x);
    }

    @Override
    public double getGenericDouble3() {
        return this.getRawLong(3);
    }

    @Override
    public void setDouble3(double x) {
        this.setRawLong(3, (long)x);
    }

    @Override
    public double getDouble3() {
        return this.getRawLong(3);
    }

    @Override
    public void set3(Value x) {
        this.setRawLong(3, x.getRawValue());
    }

    @Override
    public Value get3() {
        return Value.createDouble(this.getRawLong(3));
    }

    @Override
    public void setRawLong4(long x) {
        this.setRawLong(4, x);
    }

    @Override
    public long getRawLong4() {
        return this.getRawLong(4);
    }

    @Override
    public void setGenericDouble4(double x) {
        this.setRawLong(4, (long)x);
    }

    @Override
    public double getGenericDouble4() {
        return this.getRawLong(4);
    }

    @Override
    public void setDouble4(double x) {
        this.setRawLong(4, (long)x);
    }

    @Override
    public double getDouble4() {
        return this.getRawLong(4);
    }

    @Override
    public void set4(Value x) {
        this.setRawLong(4, x.getRawValue());
    }

    @Override
    public Value get4() {
        return Value.createDouble(this.getRawLong(4));
    }

    @Override
    public void setRawLong5(long x) {
        this.setRawLong(5, x);
    }

    @Override
    public long getRawLong5() {
        return this.getRawLong(5);
    }

    @Override
    public void setGenericDouble5(double x) {
        this.setRawLong(5, (long)x);
    }

    @Override
    public double getGenericDouble5() {
        return this.getRawLong(5);
    }

    @Override
    public void setDouble5(double x) {
        this.setRawLong(5, (long)x);
    }

    @Override
    public double getDouble5() {
        return this.getRawLong(5);
    }

    @Override
    public void set5(Value x) {
        this.setRawLong(5, x.getRawValue());
    }

    @Override
    public Value get5() {
        return Value.createDouble(this.getRawLong(5));
    }

    @Override
    public void setRawLong6(long x) {
        this.setRawLong(6, x);
    }

    @Override
    public long getRawLong6() {
        return this.getRawLong(6);
    }

    @Override
    public void setGenericDouble6(double x) {
        this.setRawLong(6, (long)x);
    }

    @Override
    public double getGenericDouble6() {
        return this.getRawLong(6);
    }

    @Override
    public void setDouble6(double x) {
        this.setRawLong(6, (long)x);
    }

    @Override
    public double getDouble6() {
        return this.getRawLong(6);
    }

    @Override
    public void set6(Value x) {
        this.setRawLong(6, x.getRawValue());
    }

    @Override
    public Value get6() {
        return Value.createDouble(this.getRawLong(6));
    }

    @Override
    public void setRawLong7(long x) {
        this.setRawLong(7, x);
    }

    @Override
    public long getRawLong7() {
        return this.getRawLong(7);
    }

    @Override
    public void setGenericDouble7(double x) {
        this.setRawLong(7, (long)x);
    }

    @Override
    public double getGenericDouble7() {
        return this.getRawLong(7);
    }

    @Override
    public void setDouble7(double x) {
        this.setRawLong(7, (long)x);
    }

    @Override
    public double getDouble7() {
        return this.getRawLong(7);
    }

    @Override
    public void set7(Value x) {
        this.setRawLong(7, x.getRawValue());
    }

    @Override
    public Value get7() {
        return Value.createDouble(this.getRawLong(7));
    }
}

