/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

public final class NativeUtils {
    private NativeUtils() {
    }

    public static Value caml_array_get_addr(Value array, long index) throws FailException {
        if (index < 0L || index >= array.sizeValues()) {
            Fail.arrayBoundError();
        }
        return array.get(index);
    }

    public static double caml_array_get_float(Value array, long index) throws FailException {
        if (index < 0L || index >= array.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        return array.getDouble(index);
    }

    public static long caml_array_get_int(Value array, long index) throws FailException {
        if (index < 0L || index >= array.sizeLongs()) {
            Fail.arrayBoundError();
        }
        return array.getRawLong(index);
    }

    public static Value caml_array_get(Value array, long index) throws FailException {
        if (array.isDoubleArray()) {
            return Value.createDouble(NativeUtils.caml_array_get_float(array, index));
        }
        return NativeUtils.caml_array_get_addr(array, index);
    }

    public static Value caml_array_set_addr(Value array, long index, Value val) throws FailException {
        if (index < 0L || index >= array.sizeValues()) {
            Fail.arrayBoundError();
        }
        array.set(index, val);
        return Value.UNIT;
    }

    public static Value caml_array_set_float(Value array, long index, double val) throws FailException {
        if (index < 0L || index >= array.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        array.setDouble(index, val);
        return Value.UNIT;
    }

    public static Value caml_array_set_int(Value array, long index, long val) throws FailException {
        if (index < 0L || index >= array.sizeLongs()) {
            Fail.arrayBoundError();
        }
        array.setRawLong(index, val);
        return Value.UNIT;
    }

    public static Value caml_array_set(Value array, long index, Value val) throws FailException {
        if (array.isDoubleArray()) {
            return NativeUtils.caml_array_set_float(array, index, val.asDouble());
        }
        return NativeUtils.caml_array_set_addr(array, index, val);
    }

    public static Value caml_array_unsafe_get(Value array, long index) {
        if (array.isDoubleArray()) {
            return Value.createDouble(array.getDouble(index));
        }
        return array.get(index);
    }

    public static Value caml_array_unsafe_set(Value array, long index, Value val) {
        if (array.isDoubleArray()) {
            array.setDouble(index, val.asDouble());
            return Value.UNIT;
        }
        array.set(index, val);
        return Value.UNIT;
    }

    public static long caml_string_get(Value s, long idx) throws FailException {
        if (idx < 0L || idx >= s.sizeBytes()) {
            Fail.arrayBoundError();
        }
        return s.getUnsignedByte(idx);
    }

    public static Value caml_string_set(Value s, long idx, long v) throws FailException {
        if (idx < 0L || idx >= s.sizeBytes()) {
            Fail.arrayBoundError();
        }
        s.setUnsignedByte(idx, (int)v);
        return Value.UNIT;
    }

    public static boolean caml_bitvect_test(Value s, long pos) {
        return (s.getUnsignedByte(pos >> 3) & 1 << (int)(pos & 7L)) != 0;
    }
}

