/*
 * Decompiled with CFR 0.152.
 */
package itcl.lang;

import itcl.lang.BiCmds;
import itcl.lang.Class;
import itcl.lang.ItclClass;
import itcl.lang.ItclHierIter;
import itcl.lang.ItclInt;
import itcl.lang.ItclObjectInfo;
import itcl.lang.ItclVarDefn;
import itcl.lang.ItclVarLookup;
import itcl.lang.Itcl_ListElem;
import itcl.lang.Itcl_Stack;
import itcl.lang.Methods;
import itcl.lang.Migrate;
import itcl.lang.ProtectionCmdInfo;
import itcl.lang.Util;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.ItclAccess;
import tcl.lang.Namespace;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

class Parse {
    Parse() {
    }

    static void ParseInit(Interp interp, ItclObjectInfo info) throws TclException {
        Namespace parserNs = Namespace.createNamespace((Interp)interp, (String)"::itcl::parser", null);
        if (parserNs == null) {
            throw new TclException(interp, "  (cannot initialize itcl parser)");
        }
        interp.createCommand("::itcl::parser::inherit", (Command)new ClassInheritCmd());
        interp.createCommand("::itcl::parser::constructor", (Command)new ClassConstructorCmd());
        interp.createCommand("::itcl::parser::destructor", (Command)new ClassDestructorCmd());
        interp.createCommand("::itcl::parser::method", (Command)new ClassMethodCmd());
        interp.createCommand("::itcl::parser::proc", (Command)new ClassProcCmd());
        interp.createCommand("::itcl::parser::common", (Command)new ClassCommonCmd());
        interp.createCommand("::itcl::parser::variable", (Command)new ClassVariableCmd());
        ProtectionCmdInfo pInfo = new ProtectionCmdInfo();
        pInfo.pLevel = 1;
        pInfo.info = info;
        interp.createCommand("::itcl::parser::public", (Command)new ClassProtectionCmd(pInfo));
        pInfo = new ProtectionCmdInfo();
        pInfo.pLevel = 2;
        pInfo.info = info;
        interp.createCommand("::itcl::parser::protected", (Command)new ClassProtectionCmd(pInfo));
        pInfo = new ProtectionCmdInfo();
        pInfo.pLevel = 3;
        pInfo.info = info;
        interp.createCommand("::itcl::parser::private", (Command)new ClassProtectionCmd(pInfo));
        ParseVarResolverImpl resolver = new ParseVarResolverImpl();
        Namespace.setNamespaceResolver((Namespace)parserNs, (Resolver)resolver);
        interp.createCommand("::itcl::class", (Command)new ClassCmd(info));
        Util.PreserveData(info);
    }

    static void ClassInheritCmdInheritError(Interp interp, ItclClass cdefn, String exmsg) throws TclException {
        Namespace.popCallFrame((Interp)interp);
        Itcl_ListElem elem = Util.FirstListElem(cdefn.bases);
        while (elem != null) {
            ItclClass baseDefn = (ItclClass)Util.GetListValue(elem);
            Util.ReleaseData(baseDefn);
            elem = Util.DeleteListElem(elem);
        }
        throw new TclException(interp, exmsg);
    }

    static Var ParseVarResolver(Interp interp, String name, Namespace contextNs, int flags) throws TclException {
        ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
        ItclClass cdefn = (ItclClass)Util.PeekStack(info.cdefnStack);
        ItclVarLookup vlookup = (ItclVarLookup)cdefn.resolveVars.get(name);
        if (vlookup != null && (vlookup.vdefn.member.flags & ItclInt.COMMON) != 0) {
            if (!vlookup.accessible) {
                throw new TclException(interp, "can't access \"" + name + "\": " + Util.ProtectionStr(vlookup.vdefn.member.protection) + " variable");
            }
            return vlookup.common;
        }
        return null;
    }

    static void FreeParserCommandData(Object cdata) {
    }

    static class ParseVarResolverImpl
    implements Resolver {
        ParseVarResolverImpl() {
        }

        public WrappedCommand resolveCmd(Interp interp, String name, Namespace context, int flags) throws TclException {
            return null;
        }

        public Var resolveVar(Interp interp, String name, Namespace context, int flags) throws TclException {
            return Parse.ParseVarResolver(interp, name, context, flags);
        }
    }

    static class ClassCommonCmd
    implements Command {
        ClassCommonCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            TclObject val;
            ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass cdefn = (ItclClass)Util.PeekStack(info.cdefnStack);
            if (objv.length < 2 || objv.length > 3) {
                throw new TclNumArgsException(interp, 1, objv, "varname ?init?");
            }
            String name = objv[1].toString();
            if (name.indexOf("::") != -1) {
                throw new TclException(interp, "bad variable name \"" + name + "\"");
            }
            String init = null;
            if (objv.length >= 3) {
                init = objv[2].toString();
            }
            ItclVarDefn vdefn = Class.CreateVarDefn(interp, cdefn, name, init, null);
            vdefn.member.flags |= ItclInt.COMMON;
            Namespace ns = cdefn.namesp;
            Var var = Migrate.NewVar();
            ItclAccess.createCommonVar(var, vdefn.member.name, ns, ns.varTable);
            ns.varTable.put(vdefn.member.name, var);
            Class.BuildVirtualTables(cdefn);
            if (init != null && (val = interp.setVar(vdefn.member.name.toString(), TclString.newInstance((String)init), 2)) == null) {
                throw new TclException(interp, "cannot initialize common variable \"" + vdefn.member.name + "\"");
            }
        }
    }

    static class ClassVariableCmd
    implements Command {
        ClassVariableCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            String name;
            ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass cdefn = (ItclClass)Util.PeekStack(info.cdefnStack);
            int pLevel = Util.Protection(interp, 0);
            if (pLevel == 1) {
                if (objv.length < 2 || objv.length > 4) {
                    throw new TclNumArgsException(interp, 1, objv, "name ?init? ?config?");
                }
            } else if (objv.length < 2 || objv.length > 3) {
                throw new TclNumArgsException(interp, 1, objv, "name ?init?");
            }
            if ((name = objv[1].toString()).indexOf("::") != -1) {
                throw new TclException(interp, "bad variable name \"" + name + "\"");
            }
            String init = null;
            String config = null;
            if (objv.length >= 3) {
                init = objv[2].toString();
            }
            if (objv.length >= 4) {
                config = objv[3].toString();
            }
            ItclVarDefn vdefn = Class.CreateVarDefn(interp, cdefn, name, init, config);
        }
    }

    static class ClassProcCmd
    implements Command {
        ClassProcCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass cdefn = (ItclClass)Util.PeekStack(info.cdefnStack);
            if (objv.length < 2 || objv.length > 4) {
                throw new TclNumArgsException(interp, 1, objv, "name ?args? ?body?");
            }
            String name = objv[1].toString();
            String arglist = null;
            String body = null;
            if (objv.length >= 3) {
                arglist = objv[2].toString();
            }
            if (objv.length >= 4) {
                body = objv[3].toString();
            }
            Methods.CreateProc(interp, cdefn, name, arglist, body);
        }
    }

    static class ClassMethodCmd
    implements Command {
        ClassMethodCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass cdefn = (ItclClass)Util.PeekStack(info.cdefnStack);
            if (objv.length < 2 || objv.length > 4) {
                throw new TclNumArgsException(interp, 1, objv, "name ?args? ?body?");
            }
            String name = objv[1].toString();
            String arglist = null;
            String body = null;
            if (objv.length >= 3) {
                arglist = objv[2].toString();
            }
            if (objv.length == 4) {
                body = objv[3].toString();
            }
            Methods.CreateMethod(interp, cdefn, name, arglist, body);
        }
    }

    static class ClassDestructorCmd
    implements Command {
        ClassDestructorCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass cdefn = (ItclClass)Util.PeekStack(info.cdefnStack);
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "body");
            }
            String name = objv[0].toString();
            String body = objv[1].toString();
            if (cdefn.functions.get(name) != null) {
                throw new TclException(interp, "\"" + name + "\" already defined in class \"" + cdefn.fullname + "\"");
            }
            Methods.CreateMethod(interp, cdefn, name, null, body);
        }
    }

    static class ClassConstructorCmd
    implements Command {
        ClassConstructorCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            String body;
            ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass cdefn = (ItclClass)Util.PeekStack(info.cdefnStack);
            if (objv.length < 3 || objv.length > 4) {
                throw new TclNumArgsException(interp, 1, objv, "args ?init? body");
            }
            String name = objv[0].toString();
            if (cdefn.functions.get(name) != null) {
                throw new TclException(interp, "\"" + name + "\" already defined in class \"" + cdefn.fullname + "\"");
            }
            String arglist = objv[1].toString();
            if (objv.length == 3) {
                body = objv[2].toString();
            } else {
                cdefn.initCode = objv[2];
                cdefn.initCode.preserve();
                body = objv[3].toString();
            }
            Methods.CreateMethod(interp, cdefn, name, arglist, body);
        }
    }

    static class ClassProtectionCmd
    implements CommandWithDispose {
        ProtectionCmdInfo pInfo;

        public ClassProtectionCmd(ProtectionCmdInfo pInfo) {
            this.pInfo = pInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 2) {
                throw new TclNumArgsException(interp, 1, objv, "command ?arg arg...?");
            }
            int oldLevel = Util.Protection(interp, this.pInfo.pLevel);
            try {
                if (objv.length == 2) {
                    interp.eval(objv[1].toString());
                } else {
                    TclObject cmdline = Util.CreateArgs(interp, null, objv, 1);
                    TclObject[] cmdlinev = TclList.getElements((Interp)interp, (TclObject)cmdline);
                    Util.EvalArgs(interp, cmdlinev);
                }
            }
            catch (TclException ex) {
                interp.addErrorInfo("\n    (" + objv[0].toString() + " body line " + interp.getErrorLine() + ")");
            }
            finally {
                Util.Protection(interp, oldLevel);
            }
        }

        public void disposeCmd() {
            Parse.FreeParserCommandData(this.pInfo);
        }
    }

    static class ClassInheritCmd
    implements Command {
        ClassInheritCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass cd;
            ItclClass baseCdefn;
            ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
            ItclClass cdefn = (ItclClass)Util.PeekStack(info.cdefnStack);
            boolean newEntry = true;
            if (objv.length < 2) {
                throw new TclNumArgsException(interp, 1, objv, "class ?class...?");
            }
            Itcl_ListElem elem = Util.FirstListElem(cdefn.bases);
            if (elem != null) {
                StringBuffer msg = new StringBuffer(64);
                msg.append("inheritance \"");
                while (elem != null) {
                    ItclClass cd2 = (ItclClass)Util.GetListValue(elem);
                    msg.append(cd2.name);
                    msg.append(" ");
                    elem = Util.NextListElem(elem);
                }
                msg.append("\" already defined for class \"");
                msg.append(cdefn.fullname);
                msg.append("\"");
                throw new TclException(interp, msg.toString());
            }
            CallFrame frame = ItclAccess.newCallFrame(interp);
            Namespace.pushCallFrame((Interp)interp, (CallFrame)frame, (Namespace)cdefn.namesp.parent, (boolean)false);
            for (int i = 1; i < objv.length; ++i) {
                String token = objv[i].toString();
                baseCdefn = Class.FindClass(interp, token, true);
                if (baseCdefn == null) {
                    String errmsg = interp.getResult().toString();
                    interp.resetResult();
                    StringBuffer msg = new StringBuffer(64);
                    msg.append("cannot inherit from \"");
                    msg.append(token);
                    msg.append("\"");
                    if (errmsg.length() > 0) {
                        msg.append(" (");
                        msg.append(errmsg);
                        msg.append(")");
                    }
                    Parse.ClassInheritCmdInheritError(interp, cdefn, msg.toString());
                }
                if (baseCdefn == cdefn) {
                    Parse.ClassInheritCmdInheritError(interp, cdefn, "class \"" + cdefn.name + "\" cannot inherit from itself");
                }
                Util.AppendList(cdefn.bases, baseCdefn);
                Util.PreserveData(baseCdefn);
            }
            elem = Util.FirstListElem(cdefn.bases);
            while (elem != null) {
                Itcl_ListElem elem2 = Util.NextListElem(elem);
                while (elem2 != null) {
                    if (Util.GetListValue(elem) == Util.GetListValue(elem2)) {
                        cd = (ItclClass)Util.GetListValue(elem);
                        String msg = "class \"" + cdefn.fullname + "\" cannot inherit base class \"" + cd.fullname + "\" more than once";
                        Parse.ClassInheritCmdInheritError(interp, cdefn, msg);
                    }
                    elem2 = Util.NextListElem(elem2);
                }
                elem = Util.NextListElem(elem);
            }
            ItclHierIter hier = new ItclHierIter();
            Class.InitHierIter(hier, cdefn);
            cd = Class.AdvanceHierIter(hier);
            cd = Class.AdvanceHierIter(hier);
            while (cd != null) {
                String prev = cdefn.heritage.put(cd, "");
                boolean bl = newEntry = prev == null;
                if (!newEntry) break;
                cd = Class.AdvanceHierIter(hier);
            }
            Class.DeleteHierIter(hier);
            if (!newEntry) {
                StringBuffer msg = new StringBuffer(64);
                ItclClass badCd = cd;
                msg.append("class \"");
                msg.append(cdefn.fullname);
                msg.append("\" inherits base class \"");
                msg.append(badCd.fullname);
                msg.append("\" more than once:");
                cd = cdefn;
                Itcl_Stack stack = new Itcl_Stack();
                Util.InitStack(stack);
                Util.PushStack(cd, stack);
                while (Util.GetStackSize(stack) > 0) {
                    cd = (ItclClass)Util.PopStack(stack);
                    if (cd == badCd) {
                        msg.append("\n  ");
                        for (int i = 0; i < Util.GetStackSize(stack); ++i) {
                            if (Util.GetStackValue(stack, i) != null) continue;
                            cd = (ItclClass)Util.GetStackValue(stack, i - 1);
                            msg.append(cd.name);
                            msg.append("->");
                        }
                        msg.append(badCd.name);
                        continue;
                    }
                    if (cd == null) {
                        Util.PopStack(stack);
                        continue;
                    }
                    elem = Util.LastListElem(cd.bases);
                    if (elem == null) continue;
                    Util.PushStack(cd, stack);
                    Util.PushStack(null, stack);
                    while (elem != null) {
                        Util.PushStack(Util.GetListValue(elem), stack);
                        elem = Util.PrevListElem(elem);
                    }
                }
                Util.DeleteStack(stack);
                Parse.ClassInheritCmdInheritError(interp, cdefn, msg.toString());
            }
            elem = Util.FirstListElem(cdefn.bases);
            while (elem != null) {
                baseCdefn = (ItclClass)Util.GetListValue(elem);
                Util.AppendList(baseCdefn.derived, cdefn);
                Util.PreserveData(cdefn);
                elem = Util.NextListElem(elem);
            }
            Namespace.popCallFrame((Interp)interp);
        }
    }

    static class ClassCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        ClassCmd(ItclObjectInfo info) {
            this.info = info;
        }

        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length != 3) {
                throw new TclNumArgsException(interp, 1, objv, "name { definition }");
            }
            String className = objv[1].toString();
            if (className.length() == 0) {
                throw new TclException(interp, "invalid class name \"\"");
            }
            Namespace parserNs = Namespace.findNamespace((Interp)interp, (String)"::itcl::parser", null, (int)512);
            if (parserNs == null) {
                interp.addErrorInfo("\n    (while parsing class definition for \"" + className + "\")");
                throw new TclException(interp, interp.getResult().toString());
            }
            ItclClass cdefn = Class.CreateClass(interp, className, this.info);
            try {
                Namespace.importList((Interp)interp, (Namespace)cdefn.namesp, (String)"::itcl::builtin::*", (boolean)true);
            }
            catch (TclException ex) {
                interp.addErrorInfo("\n    (while installing built-in commands for class \"" + className + "\")");
                Namespace.deleteNamespace((Namespace)cdefn.namesp);
                throw ex;
            }
            Util.PushStack(cdefn, this.info.cdefnStack);
            TclException pex = null;
            boolean pushed = false;
            try {
                CallFrame frame = ItclAccess.newCallFrame(interp);
                Namespace.pushCallFrame((Interp)interp, (CallFrame)frame, (Namespace)parserNs, (boolean)false);
                pushed = true;
                interp.eval(objv[2].toString());
            }
            catch (TclException ex) {
                pex = ex;
            }
            finally {
                if (pushed) {
                    Namespace.popCallFrame((Interp)interp);
                }
            }
            Util.PopStack(this.info.cdefnStack);
            if (pex != null) {
                interp.addErrorInfo("\n    (class \"" + className + "\" body line " + interp.getErrorLine() + ")");
                Namespace.deleteNamespace((Namespace)cdefn.namesp);
                throw pex;
            }
            try {
                BiCmds.InstallBiMethods(interp, cdefn);
            }
            catch (TclException ex) {
                Namespace.deleteNamespace((Namespace)cdefn.namesp);
                throw ex;
            }
            Class.BuildVirtualTables(cdefn);
            interp.resetResult();
        }
    }
}

