/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.javalib;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Debug;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.NativeArithmetic;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.javalib.MethodMapping;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[XXX]", module="[XXX]", source="XXX.c")
public final class Java {
    private Java() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a"}, returnType="java'lang'Object java_instance")
    public static Value ocamljava_object_of_value(Value val) {
        return Value.createInstance(val);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'lang'Object java_instance"}, returnType="'a")
    public static Value ocamljava_value_of_object(Value obj) {
        return (Value)obj.asCustom();
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="JavaString.t array")
    public static Value ocamljava_get_argv(Value unit) {
        String[] args = CurrentContext.getParameters().getArguments();
        int len = args.length;
        Value res = Value.createBlock(0, len);
        for (int i = 0; i < len; ++i) {
            res.set(i, Value.createInstance(args[i]));
        }
        return res;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="JavaString.t array")
    public static Value ocamljava_get_argv$() {
        String[] args = CurrentContext.getParameters().getArguments();
        int len = args.length;
        Value res = Value.createBlock(0, len);
        for (int i = 0; i < len; ++i) {
            res.set(i, Value.createInstance(args[i]));
        }
        return res;
    }

    private static Object makeProxy(ClassLoader cl, Class<?>[] il, Value o, MethodMapping m) {
        CodeRunner cr = OCamlJavaThread.getCodeRunner();
        ProxyInvocationHandler ih = new ProxyInvocationHandler(o, cr, m);
        Object res = Proxy.newProxyInstance(cl, il, (InvocationHandler)ih);
        return res;
    }

    public static Object ocamljava_java_make_proxy_loader(Class<?>[] il, ClassLoader cl, Value o, MethodMapping m) {
        return Java.makeProxy(cl, il, o, m);
    }

    public static Object ocamljava_java_make_proxy(Class<?>[] il, Value o, MethodMapping m) {
        return Java.makeProxy(ClassLoader.getSystemClassLoader(), il, o, m);
    }

    public static Object ocamljava_java_make_proxy_system(Class<?>[] il, Value o, MethodMapping m) {
        return Java.makeProxy(ClassLoader.getSystemClassLoader(), il, o, m);
    }

    public static Object ocamljava_java_make_proxy_runtime(Class<?>[] il, Value o, MethodMapping m) {
        return Java.makeProxy(Java.class.getClassLoader(), il, o, m);
    }

    private static Object unconvert(Value v, Class<?> type) {
        Debug.begin();
        if (Debug.ENABLED) {
            System.out.println("XXX proxy/unconvert v = " + v);
        }
        if (Debug.ENABLED) {
            System.out.println("XXX proxy/unconvert t = " + type);
        }
        Debug.end();
        if (Value.class.equals(type)) {
            return v;
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return v != Value.FALSE ? Boolean.TRUE : Boolean.FALSE;
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return (byte)v.asLong();
        }
        if (Character.class.equals(type) || Character.TYPE.equals(type)) {
            return Character.valueOf((char)v.asLong());
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return v.asDouble();
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return Float.valueOf((float)v.asDouble());
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return v.asInt32();
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return v.asInt64();
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return (short)v.asLong();
        }
        if (Void.TYPE.equals(type)) {
            return null;
        }
        return v.asCustom();
    }

    private static Value convert(Object v, Class<?> type) {
        if (Value.class.equals(type)) {
            return (Value)v;
        }
        if (Boolean.class.equals(type)) {
            return (Boolean)v != false ? Value.TRUE : Value.FALSE;
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return Value.createLong(((Byte)v).byteValue());
        }
        if (Character.class.equals(type) || Character.TYPE.equals(type)) {
            return Value.createLong(((Character)v).charValue());
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return Value.createDouble((Double)v);
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return Value.createDouble(((Float)v).floatValue());
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return Value.createInt32((Integer)v);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return Value.createInt64((Long)v);
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return Value.createLong(((Short)v).shortValue());
        }
        return Value.createInstance(v);
    }

    private static final long methodTag(String name) {
        long res = 1L;
        long const223 = 447L;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            long ch = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(name.charAt(i)));
            res = NativeArithmetic.mulint(447L, res);
            res = NativeArithmetic.addint(res, ch << 1 | 1L);
        }
        long accu = res >> 1;
        accu = (accu &= Integer.MAX_VALUE) > 0x3FFFFFFFL ? accu - 0x80000000L : accu;
        return accu << 1 | 1L;
    }

    static class ProxyInvocationHandler
    implements InvocationHandler {
        private final Value instance;
        private final CodeRunner runner;
        private final MethodMapping mapping;
        private final Map<Method, Value> cache;

        ProxyInvocationHandler(Value i, CodeRunner cr, MethodMapping mm) {
            assert (i != null) : "null i";
            assert (cr != null) : "null cr";
            assert (mm != null) : "null mm";
            this.instance = i;
            this.runner = cr;
            this.mapping = mm;
            this.cache = new HashMap<Method, Value>();
        }

        private Value getClosure(Method method) {
            Debug.begin();
            if (Debug.ENABLED) {
                System.out.println("XXX getClosure/1 = " + method);
            }
            if (Debug.ENABLED) {
                System.out.println("XXX getClosure/2 = " + this.mapping.get(method));
            }
            Debug.end();
            Value cached = this.cache.get(method);
            if (cached == null) {
                String name = this.mapping.get(method);
                if (name == null) {
                    return null;
                }
                Value clos = AbstractCodeRunner.getMethod(this.instance, Java.methodTag(name));
                this.cache.put(method, clos);
                return clos;
            }
            return cached;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Value clos = this.getClosure(method);
            if (clos == null) {
                return method.invoke((Object)this, args);
            }
            int len = args == null ? 0 : args.length;
            Value[] params = new Value[len + 1];
            Class<?>[] types = method.getParameterTypes();
            params[0] = this.instance;
            for (int i = 0; i < len; ++i) {
                Value tmp;
                params[i + 1] = tmp = Java.convert(args[i], types[i]);
            }
            OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
            Value tmp_apply = NativeApply.apply(clos, params);
            Object tmp_unconverted = Java.unconvert(tmp_apply, method.getReturnType());
            return tmp_unconverted;
        }
    }
}

