/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.FutureCallable;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ThreadFactory;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ThreadPoolExecutor", source="")
public final class ThreadPoolExecutor {
    private ThreadPoolExecutor() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "int32", "int64", "TimeUnit.t", "RejectedExecutionHandler.t"}, returnType="ThreadPoolExecutor.t")
    public static Value ocamljava_threadpoolexecutor_make(Value corePoolSize, Value maximumPoolSize, Value keepAliveTime, Value unit, Value handler) throws FailException {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory = new ThreadFactory(OCamlJavaThread.getCodeRunner());
        java.util.concurrent.ThreadPoolExecutor inst = new java.util.concurrent.ThreadPoolExecutor(corePoolSize.asInt32(), maximumPoolSize.asInt32(), keepAliveTime.asInt64(), (TimeUnit)((Object)unit.asCustom()), workQueue, threadFactory, (RejectedExecutionHandler)handler.asCustom());
        return Value.createInstance(inst);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "int32", "int64", "TimeUnit.t", "RejectedExecutionHandler.t"}, returnType="ThreadPoolExecutor.t")
    public static java.util.concurrent.ThreadPoolExecutor ocamljava_threadpoolexecutor_make$(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler) throws FailException {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory = new ThreadFactory(OCamlJavaThread.getCodeRunner());
        java.util.concurrent.ThreadPoolExecutor inst = new java.util.concurrent.ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        return inst;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all(Value obj, Value tasks) throws FailException, Throwable {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        return ThreadPoolExecutor.encodeFutureList(inst.invokeAll(l));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all$(java.util.concurrent.ThreadPoolExecutor inst, Value tasks) throws FailException, Throwable {
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        return ThreadPoolExecutor.encodeFutureList(inst.invokeAll(l));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all_time(Value obj, Value tasks, Value timeout, Value unit) throws FailException, Throwable {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        return ThreadPoolExecutor.encodeFutureList(inst.invokeAll(l, timeout.asInt64(), (TimeUnit)((Object)unit.asCustom())));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_all_time$(java.util.concurrent.ThreadPoolExecutor inst, Value tasks, long timeout, TimeUnit unit) throws FailException, Throwable {
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        return ThreadPoolExecutor.encodeFutureList(inst.invokeAll(l, timeout, unit));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any(Value obj, Value tasks) throws FailException, Throwable {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        return inst.invokeAny(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any$(java.util.concurrent.ThreadPoolExecutor inst, Value tasks) throws FailException, Throwable {
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        return inst.invokeAny(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any_time(Value obj, Value tasks, Value timeout, Value unit) throws FailException, Throwable {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        return inst.invokeAny(l, timeout.asInt64(), (TimeUnit)((Object)unit.asCustom()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "(unit -> 'a) list", "int64", "TimeUnit.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_invoke_any_time$(java.util.concurrent.ThreadPoolExecutor inst, Value tasks, long timeout, TimeUnit unit) throws FailException, Throwable {
        List<Callable<Value>> l = ThreadPoolExecutor.decodeCallableList(tasks);
        return inst.invokeAny(l, timeout, unit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_shutdown_now(Value obj) {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return ThreadPoolExecutor.encodeRunnableList(inst.shutdownNow());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="'a Future.t list")
    public static Value ocamljava_threadpoolexecutor_shutdown_now$(java.util.concurrent.ThreadPoolExecutor inst) {
        return ThreadPoolExecutor.encodeRunnableList(inst.shutdownNow());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "('a -> 'b)", "'a"}, returnType="'b Future.t")
    public static Value ocamljava_threadpoolexecutor_submit(Value obj, Value task, Value value) throws FailException {
        java.util.concurrent.ThreadPoolExecutor inst = (java.util.concurrent.ThreadPoolExecutor)obj.asCustom();
        return Value.createInstance(inst.submit(new FutureCallable(task, value)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t", "('a -> 'b)", "'a"}, returnType="'b Future.t")
    public static Future<Value> ocamljava_threadpoolexecutor_submit$(java.util.concurrent.ThreadPoolExecutor inst, Value task, Value value) throws FailException {
        return inst.submit(new FutureCallable(task, value));
    }

    static List<Callable<Value>> decodeCallableList(Value l) {
        LinkedList<Callable<Value>> res = new LinkedList<Callable<Value>>();
        Value ptr = l;
        while (ptr.isBlock()) {
            res.add(new FutureCallable(ptr.get0(), Value.UNIT));
            ptr = ptr.get1();
        }
        return res;
    }

    static Value encodeFutureList(List<Future<Value>> l) {
        Value res = Value.EMPTY_LIST;
        ListIterator<Future<Value>> it = l.listIterator(l.size());
        while (it.hasPrevious()) {
            res = Value.createBlock(0, Value.createInstance(it.previous()), res);
        }
        return res;
    }

    static Value encodeRunnableList(List<Runnable> l) {
        Value res = Value.EMPTY_LIST;
        ListIterator<Runnable> it = l.listIterator(l.size());
        while (it.hasPrevious()) {
            Runnable elem = it.previous();
            if (!(elem instanceof RunnableFuture)) continue;
            res = Value.createBlock(0, Value.createInstance(elem), res);
        }
        return res;
    }
}

