/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.StandardError;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;
import org.ocamljava.runtime.values.Value;

final class SimpleThread
extends Thread {
    private final CodeRunner codeRunner;
    private final Value closure;
    private final Value value;
    private static final AtomicInteger NEXT_THREAD_ID = new AtomicInteger();

    SimpleThread(ThreadGroup tg, String n, CodeRunner cr, Value c, Value v) {
        super(tg, SimpleThread.getName(n));
        this.codeRunner = cr;
        this.closure = c;
        this.value = v;
    }

    private static String getName(String name) {
        if (name != null) {
            return name;
        }
        return "OCaml-Java-User-Thread-" + SimpleThread.nextThreadID();
    }

    private static int nextThreadID() {
        return NEXT_THREAD_ID.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OCamlJavaThread.registerCodeRunner(this, this.codeRunner);
        try {
            NativeApply.apply(this.closure, this.value);
        }
        catch (Throwable t) {
            StandardError.reportThreadException(this, t);
        }
        finally {
            ThreadLocalFactory.remove();
        }
    }
}

