/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.FutureCallable;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ThreadFactory;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ScheduledThreadPoolExecutor", source="")
public final class ScheduledThreadPoolExecutor {
    private ScheduledThreadPoolExecutor() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "RejectedExecutionHandler.t"}, returnType="ScheduledThreadPoolExecutor.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_make(Value corePoolSize, Value handler) throws FailException {
        ThreadFactory threadFactory = new ThreadFactory((AbstractNativeRunner)OCamlJavaThread.getCodeRunner());
        java.util.concurrent.ScheduledThreadPoolExecutor inst = new java.util.concurrent.ScheduledThreadPoolExecutor(corePoolSize.asInt32(), threadFactory, (RejectedExecutionHandler)handler.asCustom());
        return Value.createInstance(inst);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "RejectedExecutionHandler.t"}, returnType="ScheduledThreadPoolExecutor.t")
    public static java.util.concurrent.ScheduledThreadPoolExecutor ocamljava_scheduledthreadpoolexecutor_make$(int corePoolSize, RejectedExecutionHandler handler) throws FailException {
        ThreadFactory threadFactory = new ThreadFactory((AbstractNativeRunner)OCamlJavaThread.getCodeRunner());
        return new java.util.concurrent.ScheduledThreadPoolExecutor(corePoolSize, threadFactory, handler);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> 'b)", "'a", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule(Value obj, Value task, Value value, Value delay, Value unit) throws FailException {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        return Value.createInstance(inst.schedule(new FutureCallable(task, value), delay.asInt64(), (TimeUnit)((Object)unit.asCustom())));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> 'b)", "'a", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static ScheduledFuture<Value> ocamljava_scheduledthreadpoolexecutor_schedule$(java.util.concurrent.ScheduledThreadPoolExecutor inst, Value task, Value value, long delay, TimeUnit unit) throws FailException {
        return inst.schedule(new FutureCallable(task, value), delay, unit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> unit)", "'a,", "int64", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule_at_fixed_rate(Value obj, Value task, Value value, Value delay, Value period, Value unit) throws FailException {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        return Value.createInstance(inst.scheduleAtFixedRate(new FutureCallable(task, value), delay.asInt64(), period.asInt64(), (TimeUnit)((Object)unit.asCustom())));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> unit)", "'a,", "int64", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static ScheduledFuture<Value> ocamljava_scheduledthreadpoolexecutor_schedule_at_fixed_rate$(java.util.concurrent.ScheduledThreadPoolExecutor inst, Value task, Value value, long delay, long period, TimeUnit unit) throws FailException {
        return inst.scheduleAtFixedRate(new FutureCallable(task, value), delay, period, unit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> unit)", "'a,", "int64", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static Value ocamljava_scheduledthreadpoolexecutor_schedule_with_fixed_delay(Value obj, Value task, Value value, Value delay, Value period, Value unit) throws FailException {
        java.util.concurrent.ScheduledThreadPoolExecutor inst = (java.util.concurrent.ScheduledThreadPoolExecutor)obj.asCustom();
        return Value.createInstance(inst.scheduleWithFixedDelay(new FutureCallable(task, value), delay.asInt64(), period.asInt64(), (TimeUnit)((Object)unit.asCustom())));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ScheduledThreadPoolExecutor.t", "('a -> unit)", "'a,", "int64", "int64", "TimeUnit.t"}, returnType="'b ScheduledFuture.t")
    public static ScheduledFuture<Value> ocamljava_scheduledthreadpoolexecutor_schedule_with_fixed_delay$(java.util.concurrent.ScheduledThreadPoolExecutor inst, Value task, Value value, long delay, long period, TimeUnit unit) throws FailException {
        return inst.scheduleWithFixedDelay(new FutureCallable(task, value), delay, period, unit);
    }
}

