/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import org.ocamljava.runtime.context.BasicFileHook;
import org.ocamljava.runtime.context.ChannelMap;
import org.ocamljava.runtime.context.FileHook;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.values.Value;

public final class FilesState {
    private File pwd;
    private FileHook fileHook;
    private final ChannelMap channels;

    FilesState(CommonParameters p, File dir) {
        assert (p != null) : "null p";
        assert (dir != null) : "null dir";
        this.pwd = dir;
        Class<?> embBase = null;
        try {
            embBase = Class.forName(p.getEmbeddedBase());
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.fileHook = p.isEmbedded() ? new BasicFileHook(embBase) : null;
        this.channels = new ChannelMap();
        Channel stdin = new Channel(p.getStandardInput());
        Channel stdout = new Channel(p.getStandardOutput());
        Channel stderr = new Channel(p.getStandardError());
        stdin.setFD(0);
        stdout.setFD(1);
        stderr.setFD(2);
        this.channels.put(0, stdin);
        this.channels.put(1, stdout);
        this.channels.put(2, stderr);
    }

    public synchronized File getPwd() {
        return this.pwd;
    }

    public synchronized void setPwd(File path) {
        assert (path != null) : "null path";
        this.pwd = path;
    }

    public synchronized File getRealFile(String name) {
        assert (name != null) : "null name";
        File f = new File(name);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.getPwd(), name);
    }

    public synchronized File getRealFile(Value name) {
        assert (name != null) : "null name";
        return this.getRealFile(name.asString());
    }

    public synchronized String resourceNameFromPath(Value path) {
        assert (path != null) : "null path";
        String s = path.asString().replace('\\', '/');
        if (s.startsWith("/")) {
            return s;
        }
        String prefix = this.getPwd().toString();
        if (prefix.endsWith("/")) {
            return prefix + s;
        }
        return prefix + "/" + s;
    }

    public synchronized String resourceNameFromFile(File path) {
        if (path.isAbsolute()) {
            return path.toString();
        }
        return new File(this.getPwd(), path.toString()).toString();
    }

    public synchronized InputStream getInputStreamForPath(Value path) throws IOException {
        InputStream res;
        assert (path != null) : "null path";
        if (this.fileHook != null && (res = this.fileHook.getInputStream(this.resourceNameFromPath(path))) != null) {
            return res;
        }
        return new FileInputStream(this.getRealFile(path));
    }

    public synchronized URL getURLForPath(Value path) throws IOException {
        URL res;
        assert (path != null) : "null path";
        if (this.fileHook != null && (res = this.fileHook.getURL(this.resourceNameFromPath(path))) != null) {
            return res;
        }
        return this.getRealFile(path).toURI().toURL();
    }

    public synchronized OutputStream getOutputStreamForPath(Value path) throws IOException {
        return new FileOutputStream(this.getRealFile(path));
    }

    public synchronized void setFileHook(FileHook hook) {
        this.fileHook = hook;
    }

    public synchronized FileHook getFileHook() {
        return this.fileHook;
    }

    public synchronized Channel getChannel(int fd) {
        return this.channels.get(fd);
    }

    public synchronized int addChannel(Channel ch) {
        assert (ch != null) : "null ch";
        int fd = this.channels.firstAvailableKey();
        this.channels.put(fd, ch);
        ch.setFD(fd);
        return fd;
    }

    public synchronized Channel removeChannel(int fd) {
        return this.channels.remove(fd);
    }

    public synchronized boolean closeChannel(int fd) throws IOException {
        Channel ch = this.channels.remove(fd);
        if (ch != null) {
            ch.setFD(-1);
            ch.close();
            return true;
        }
        return false;
    }

    public synchronized void setChannel(int fd, Channel ch) {
        assert (ch != null) : "null ch";
        this.channels.put(fd, ch);
        ch.setFD(fd);
    }

    public synchronized Value makeOutChannelsList() {
        Value res = Value.EMPTY_LIST;
        Iterator<Channel> it = this.channels.valueIterator();
        while (it.hasNext()) {
            Channel ch = it.next();
            if (!ch.isOutputChannel()) continue;
            res = Value.createBlock(0, Value.createChannel(ch), res);
        }
        return res;
    }
}

