/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.BigArray;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

final class MemArray {
    private final ByteBuffer data;
    private final int[] dim;
    private final long flags;

    MemArray(long l, int[] nArray, ByteBuffer byteBuffer) throws FailException, FatalError {
        int n = nArray.length;
        assert (n >= 1 && n <= 16) : "invalid number of dimensions";
        assert ((l & 0xFFL) <= 11L) : "invalid element kind";
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        if (byteBuffer == null) {
            long l2 = 1L;
            for (int i = 0; i < n; ++i) {
                if ((l2 *= (long)nArray2[i]) >= 0L && l2 <= Integer.MAX_VALUE) continue;
                Fail.raiseOutOfMemory();
            }
            long l3 = l2 * (long)BigArray.CAML_BA_ELEMENT_SIZE[(int)l & 0xFF];
            if (l3 < 0L || l3 > Integer.MAX_VALUE) {
                Fail.raiseOutOfMemory();
            }
            this.data = ByteBuffer.allocate(IntegerUtils.ensure32s(l3));
            this.flags = l & 0x1FFL | 0L;
        } else {
            this.data = byteBuffer;
            this.flags = l & 0x1FFL | 0x400L;
        }
        this.dim = nArray2;
    }

    ByteBuffer getData() {
        return this.data;
    }

    int getNumDims() {
        return this.dim.length;
    }

    int[] getDims() {
        return this.dim;
    }

    int getDim(int n) throws ArrayIndexOutOfBoundsException {
        return this.dim[n];
    }

    long getFlags() {
        return this.flags;
    }

    Value get(int[] nArray) throws FailException {
        assert (nArray != null) : "null index";
        if (nArray.length != this.dim.length) {
            Fail.invalidArgument("Bigarray.get: wrong number of indices");
        }
        int n = this.offset(nArray);
        switch ((int)this.flags & 0xFF) {
            case 0: {
                return Value.createDouble(this.data.getFloat(n * 4));
            }
            case 1: {
                return Value.createDouble(this.data.getDouble(n * 8));
            }
            case 2: {
                return Value.createLong(this.data.get(n * 1));
            }
            case 3: {
                return Value.createLong(IntegerUtils.signedToUnsignedByte(this.data.get(n * 1)));
            }
            case 4: {
                return Value.createLong(this.data.getShort(n * 2));
            }
            case 5: {
                return Value.createLong(IntegerUtils.signedToUnsignedShort(this.data.getShort(n * 2)));
            }
            case 6: {
                return Value.createInt32(this.data.getInt(n * 4));
            }
            case 7: {
                return Value.createInt64(this.data.getLong(n * 8));
            }
            case 9: {
                return Value.createNativeInt(this.data.getLong(n * 8));
            }
            case 8: {
                return Value.createLong(this.data.getLong(n * 8));
            }
            case 10: {
                return Value.createDoubleArray(this.data.getFloat(n * 8), this.data.getFloat(n * 8) + 4.0f);
            }
            case 11: {
                return Value.createDoubleArray(this.data.getDouble(n * 16), this.data.getDouble(n * 16) + 8.0);
            }
        }
        assert (false) : "invalid elements kind";
        return Value.UNIT;
    }

    void set(int[] nArray, Value value) throws FailException {
        assert (nArray != null) : "null index";
        if (nArray.length != this.dim.length) {
            Fail.invalidArgument("Bigarray.set: wrong number of indices");
        }
        int n = this.offset(nArray);
        switch ((int)this.flags & 0xFF) {
            case 0: {
                this.data.putFloat(n * 4, (float)value.asDouble());
                break;
            }
            case 1: {
                this.data.putDouble(n * 8, value.asDouble());
                break;
            }
            case 2: 
            case 3: {
                this.data.put(n * 1, (byte)value.asLong());
                break;
            }
            case 4: 
            case 5: {
                this.data.putShort(n * 2, (short)value.asLong());
                break;
            }
            case 6: {
                this.data.putInt(n * 4, value.asInt32());
                break;
            }
            case 7: {
                this.data.putLong(n * 8, value.asInt64());
                break;
            }
            case 9: {
                this.data.putLong(n * 8, value.asNativeInt());
                break;
            }
            case 8: {
                this.data.putLong(n * 8, value.asLong());
                break;
            }
            case 10: {
                this.data.putFloat(n * 8, (float)value.getDouble0());
                this.data.putFloat(n * 8 + 4, (float)value.getDouble1());
                break;
            }
            case 11: {
                this.data.putDouble(n * 16, value.getDouble0());
                this.data.putDouble(n * 16 + 8, value.getDouble1());
                break;
            }
            default: {
                assert (false) : "invalid elements kind";
                break;
            }
        }
    }

    long getNumElems() {
        long l = 1L;
        int n = this.dim.length;
        for (int i = 0; i < n; ++i) {
            l *= (long)this.dim[i];
        }
        return l;
    }

    int offset(int[] nArray) throws FailException {
        assert (nArray != null) : "null index";
        int n = 0;
        if ((this.flags & 0x100L) == 0L) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= this.dim[i]) {
                    Fail.arrayBoundError();
                }
                n = n * this.dim[i] + nArray[i];
            }
        } else {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] - 1 >= this.dim[i]) {
                    Fail.arrayBoundError();
                }
                n = n * this.dim[i] + (nArray[i] - 1);
            }
        }
        return n;
    }

    void unMap() {
        ((MappedByteBuffer)this.data).force();
    }
}

