/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.DataFormat;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class MarshalExtern
implements DataFormat {
    private static final int NO_SHARING = 1;
    private static final int CLOSURES = 2;
    private static final int COMPAT_32 = 4;
    private static final int[] EXTERN_FLAGS = new int[]{1, 2, 4};

    private MarshalExtern() {
    }

    public static byte[] externValue(Context context, Value value, Value value2) throws IOException, FailException {
        assert (context != null) : "null ctxt";
        assert (value != null) : "null v";
        assert (value2 != null) : "null flags";
        int n = Misc.convertFlagList(value2, EXTERN_FLAGS);
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        LinkedList<Value> linkedList = new LinkedList<Value>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CustomOperations.SerializationSizes serializationSizes = new CustomOperations.SerializationSizes();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        IO.write32s(dataOutputStream, -2070567234);
        dataOutputStream.write(new byte[16]);
        MarshalExtern.externRec(context, dataOutputStream, value, linkedList, serializationSizes, bl, bl2, bl3);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(16);
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
        dataOutputStream2.writeInt(byArray.length - 20);
        dataOutputStream2.writeInt(linkedList.size());
        dataOutputStream2.writeInt(IntegerUtils.unsignedToSigned(serializationSizes.size32));
        dataOutputStream2.writeInt(IntegerUtils.unsignedToSigned(serializationSizes.size64));
        System.arraycopy(byteArrayOutputStream2.toByteArray(), 0, byArray, 4, 16);
        byteArrayOutputStream2.close();
        return byArray;
    }

    private static void externRec(Context context, DataOutput dataOutput, Value value, List<Value> list, CustomOperations.SerializationSizes serializationSizes, boolean bl, boolean bl2, boolean bl3) throws IOException, FailException {
        assert (context != null) : "null ctxt";
        assert (dataOutput != null) : "null out";
        assert (value != null) : "null val";
        assert (list != null) : "null objTable";
        assert (serializationSizes != null) : "null sizes";
        Value value2 = value;
        LinkedList<StackItem> linkedList = new LinkedList<StackItem>();
        boolean bl4 = false;
        block8: while (true) {
            if (bl4) {
                value2 = null;
                while (value2 == null && !linkedList.isEmpty()) {
                    StackItem stackItem = (StackItem)linkedList.get(0);
                    value2 = stackItem.nextItem();
                    if (value2 != null) continue;
                    linkedList.remove(0);
                }
                if (value2 == null) {
                    return;
                }
                bl4 = false;
            }
            if (value2.isLong()) {
                long l = value2.asLong();
                if (l >= 0L && l < 64L) {
                    IO.write8u(dataOutput, (int)l + 64);
                } else if (l >= -128L && l <= 127L) {
                    IO.write8u(dataOutput, 0);
                    IO.write8s(dataOutput, (int)l);
                } else if (l >= -32768L && l <= 32767L) {
                    IO.write8u(dataOutput, 1);
                    IO.write16s(dataOutput, (int)l);
                } else if (l < -1073741824L || l > 0x3FFFFFFFL) {
                    if (bl3) {
                        Fail.invalidArgument("output_value: integer cannot be read back on 32-bit platform");
                    } else {
                        IO.write8u(dataOutput, 3);
                        IO.write64s(dataOutput, l);
                    }
                } else {
                    IO.write8u(dataOutput, 2);
                    IO.write32s(dataOutput, (int)l);
                }
                bl4 = true;
                continue;
            }
            if (value2.isBlock()) {
                int n;
                Value value3;
                long l = value2.getHeader();
                int n2 = value2.getTag();
                long l2 = value2.getWoSize();
                if (n2 == 250 && (!(value3 = value2.get0()).isBlock() || context.getCodeState().isAtom(value3) || value3.getTag() != 250 && value3.getTag() != 246 && value3.getTag() != 253)) {
                    value2 = value3;
                    continue;
                }
                if (l2 == 0L) {
                    if (n2 < 16) {
                        IO.write8u(dataOutput, 128 + n2);
                    } else {
                        IO.write8u(dataOutput, 8);
                        IO.write32s(dataOutput, (int)l);
                    }
                    bl4 = true;
                    continue;
                }
                if (!bl && n2 != 249) {
                    int n3 = MarshalExtern.indexOf(list, value2);
                    if (n3 != -1) {
                        n = list.size() - n3;
                        if (n < 256) {
                            IO.write8u(dataOutput, 4);
                            IO.write8u(dataOutput, n);
                        } else if (n < 65536) {
                            IO.write8u(dataOutput, 5);
                            IO.write16u(dataOutput, n);
                        } else {
                            IO.write8u(dataOutput, 6);
                            IO.write32s(dataOutput, n);
                        }
                        bl4 = true;
                        continue;
                    }
                    list.add(value2);
                }
                switch (n2) {
                    case 252: {
                        int n4 = (int)value2.sizeBytes();
                        if ((long)n4 < 32L) {
                            IO.write8u(dataOutput, 32 + n4);
                        } else if ((long)n4 < 256L) {
                            IO.write8u(dataOutput, 9);
                            IO.write8u(dataOutput, n4);
                        } else if ((long)n4 > 0xFFFFFBL && bl3) {
                            Fail.invalidArgument("output_value: string cannot be read back on 32-bit platform");
                        } else {
                            IO.write8u(dataOutput, 10);
                            IO.write32u(dataOutput, n4);
                        }
                        dataOutput.write(value2.getBytes());
                        serializationSizes.size32 += (long)(1 + (n4 + 4) / 4);
                        serializationSizes.size64 += (long)(1 + (n4 + 8) / 8);
                        break;
                    }
                    case 253: {
                        IO.write8u(dataOutput, CODE_DOUBLE_NATIVE);
                        if (PlatformUtils.isBigEndianPlatform()) {
                            IO.write64s(dataOutput, Double.doubleToRawLongBits(value2.asDouble()));
                        } else {
                            IO.write64s(dataOutput, Long.reverseBytes(Double.doubleToRawLongBits(value2.asDouble())));
                        }
                        serializationSizes.size32 += 3L;
                        serializationSizes.size64 += 2L;
                        break;
                    }
                    case 254: {
                        int n5;
                        n = (int)value2.sizeDoubles();
                        if (n < 256) {
                            IO.write8u(dataOutput, CODE_DOUBLE_ARRAY8_NATIVE);
                            IO.write8u(dataOutput, n);
                        } else if (n > 0x1FFFFF && bl3) {
                            Fail.invalidArgument("output_value: float array cannot be read back on 32-bit platform");
                        } else {
                            IO.write8u(dataOutput, CODE_DOUBLE_ARRAY32_NATIVE);
                            IO.write32u(dataOutput, n);
                        }
                        if (PlatformUtils.isBigEndianPlatform()) {
                            for (n5 = 0; n5 < n; ++n5) {
                                IO.write64s(dataOutput, Double.doubleToRawLongBits(value2.getDouble(n5)));
                            }
                        } else {
                            for (n5 = 0; n5 < n; ++n5) {
                                IO.write64s(dataOutput, Long.reverseBytes(Double.doubleToRawLongBits(value2.getDouble(n5))));
                            }
                        }
                        serializationSizes.size32 += (long)(1 + n * 2);
                        serializationSizes.size64 += (long)(1 + n);
                        break;
                    }
                    case 251: {
                        Fail.invalidArgument("output_value: abstract value (Abstract)");
                        break;
                    }
                    case 249: {
                        BlockValue blockValue = value2.asBlock();
                        IO.write8u(dataOutput, 17);
                        IO.write32s(dataOutput, (int)(8L * blockValue.getWoSize()));
                        MarshalExtern.externRec(context, dataOutput, blockValue.getParent(), list, serializationSizes, bl, bl2, bl3);
                        break;
                    }
                    case 255: {
                        CustomOperations customOperations = value2.getCustomOperations();
                        if (!customOperations.isSerializable()) {
                            Fail.invalidArgument("output_value: abstract value (Custom)");
                        }
                        IO.write8u(dataOutput, 18);
                        dataOutput.write(EncodingUtils.convertStringToBytes(customOperations.getIdentifier()));
                        IO.write8u(dataOutput, 0);
                        CustomOperations.SerializationSizes serializationSizes2 = customOperations.serialize(dataOutput, value2);
                        serializationSizes.size32 += 2L + (serializationSizes2.size32 + 3L >> 2);
                        serializationSizes.size64 += 2L + (serializationSizes2.size64 + 7L >> 3);
                        break;
                    }
                    default: {
                        if (n2 < 16 && l2 < 8L) {
                            IO.write8u(dataOutput, 128 + n2 + ((int)l2 << 4));
                        } else if (l2 > Integer.MAX_VALUE) {
                            IO.write8u(dataOutput, 19);
                            IO.write64s(dataOutput, l);
                        } else if (l2 > 0x3FFFFFL && bl3) {
                            Fail.invalidArgument("output_value: array cannot be read back on 32-bit platform");
                        } else {
                            IO.write8u(dataOutput, 8);
                            IO.write32s(dataOutput, (int)l);
                        }
                        serializationSizes.size32 += 1L + l2;
                        serializationSizes.size64 += 1L + l2;
                        Value value4 = value2.get0();
                        if (l2 > 1L) {
                            linkedList.add(0, new StackItem(value2, 1L, l2));
                        }
                        value2 = value4;
                        continue block8;
                    }
                }
                bl4 = true;
                continue;
            }
            if (value2.isCodeOffset()) {
                int n = (int)value2.asCodeOffset();
                CodeState.Fragment fragment = context.getCodeState().getFragment(n);
                if (!bl2 || fragment == null) {
                    Fail.invalidArgument("output_value: functional value");
                }
                IO.write8u(dataOutput, 16);
                IO.write32s(dataOutput, n - fragment.codeStart);
                dataOutput.write(fragment.codeDigest);
                bl4 = true;
                continue;
            }
            Fail.invalidArgument("output_value: abstract value (outside heap)");
        }
    }

    private static int indexOf(List<Value> list, Value value) {
        assert (list != null) : "null objTable";
        assert (value != null) : "null v";
        Iterator<Value> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Value value2 = iterator.next();
            boolean bl = value2.isBlock();
            boolean bl2 = value.isBlock();
            if (bl && bl2 && value2 == value || !bl && !bl2 && value2.getRawValue() == value.getRawValue()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static final class StackItem {
        private final Value value;
        private long next;
        private final long size;

        StackItem(Value value, long l, long l2) {
            this.value = value;
            this.next = l;
            this.size = l2;
        }

        Value nextItem() {
            if (this.next < this.size) {
                Value value = this.value.get(this.next);
                ++this.next;
                return value;
            }
            return null;
        }
    }
}

