/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.PackerLayout;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JWindow;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.LayoutHandler;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class PackCmd
implements Command {
    static Hashtable columnTable = new Hashtable();
    static Hashtable rowTable = new Hashtable();
    private static final String[] validCmds = new String[]{"configure", "forget", "info", "propagate", "slaves"};
    private static final int OPT_CONFIGURE = 0;
    private static final int OPT_FORGET = 1;
    private static final int OPT_INFO = 2;
    private static final int OPT_PROPAGATE = 3;
    private static final int OPT_SLAVES = 4;
    static TclObject configArg = TclString.newInstance((String)"configure");
    Interp interp;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option arg ?arg ...?");
        }
        this.interp = interp;
        int firstWindow = 2;
        boolean debug = false;
        TclObject optionArg = null;
        if (!argv[1].toString().startsWith(".") && !argv[1].toString().startsWith("-")) {
            optionArg = argv[1];
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 1, argv, "option arg ?arg ...?");
            }
        } else {
            optionArg = configArg;
            firstWindow = 1;
        }
        if (debug) {
            System.out.println("Pack option is " + optionArg.toString());
        }
        int opt = TclIndex.get(interp, optionArg, validCmds, "option", 0);
        switch (opt) {
            case 0: {
                this.packConfigure(interp, argv, firstWindow);
                break;
            }
            case 1: {
                this.packForget(interp, argv, firstWindow);
                break;
            }
            case 2: {
                this.packInfo(interp, argv);
                break;
            }
            case 3: {
                this.packPropagate(interp, argv);
                break;
            }
            case 4: {
                this.packSlaves(interp, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void packInfo(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclException(interp, "wrong # args: should be \"pack info window\"");
        }
        SwkWidget window = (SwkWidget)Widgets.get(interp, argv[2].toString());
        if (window == null) {
            throw new TclException(interp, "window \"" + argv[2].toString() + "\" doesn't exist");
        }
        String result = new Info().exec(window, argv[2].toString());
        if (result == null) {
            throw new TclException(interp, "window \"" + argv[2].toString() + "\" isn't packed");
        }
        interp.setResult(result);
    }

    void packPropagate(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "window ?boolean?");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        boolean propagate = false;
        boolean setPropagate = false;
        if (argv.length == 4) {
            setPropagate = true;
            propagate = TclBoolean.get((Interp)interp, (TclObject)argv[3]);
        }
        boolean result = new Propagate().exec(argv[2].toString(), propagate, setPropagate);
        interp.setResult(result);
    }

    void packSlaves(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "window");
        }
        if (!Widgets.exists(interp, argv[2].toString())) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        String[] names = new Slaves().exec(argv[2].toString());
        TclObject list = TclList.newInstance();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)names[i]));
            }
        }
        interp.setResult(list);
    }

    void packForget(Interp interp, TclObject[] argv, int firstWindow) throws TclException {
        String[] names = new String[argv.length - firstWindow];
        int j = 0;
        for (int i = firstWindow; i < argv.length; ++i) {
            names[j++] = argv[i].toString();
        }
        new Forget().exec(names);
    }

    int initPackingWindow(Interp interp, TclObject[] argv, String[] args, int firstWindow) throws TclException {
        int lastWindow = 0;
        if (args.length <= firstWindow) {
            throw new TclNumArgsException(interp, 1, argv, "slave ?slave ...? ?options?");
        }
        if (!Widgets.exists(interp, args[firstWindow])) {
            if (firstWindow == 1) {
                throw new TclException(interp, "bad window path name \"" + args[firstWindow] + "\"");
            }
            throw new TclException(interp, "bad argument \"" + args[firstWindow] + "\": must be name of window");
        }
        int i = firstWindow;
        while (i < args.length && args[i].startsWith(".")) {
            SwkWidget window = (SwkWidget)Widgets.get(interp, args[i]);
            if (window == null) {
                throw new TclException(interp, "bad window path name \"" + args[i] + "\"");
            }
            lastWindow = i++;
        }
        if (lastWindow < firstWindow) {
            throw new TclNumArgsException(interp, 2, argv, "window");
        }
        return lastWindow;
    }

    void getSpecialArgs(Interp interp, String[] args, int lastWindow, Vector window1Special, StringBuffer strippedArgs) throws TclException {
        int firstArg = lastWindow + 1;
        int lastArg = args.length - 1;
        for (int i = firstArg; i <= lastArg; i += 2) {
            if (args[i].equals("-after") || args[i].equals("-before") || args[i].equals("-in")) {
                if (!Widgets.exists(interp, args[i + 1])) {
                    throw new TclException(interp, "bad window path name \"" + args[i + 1] + "\"");
                }
                window1Special.add(args[i]);
                window1Special.add(args[i + 1]);
                continue;
            }
            if (strippedArgs.length() != 0) {
                strippedArgs.append(" ");
            }
            strippedArgs.append(" {" + args[i] + "} {" + args[i + 1] + "}");
        }
    }

    void packConfigure(Interp interp, TclObject[] argv, int firstWindow) throws TclException {
        String[] args = new String[argv.length];
        for (int i = 0; i < argv.length; ++i) {
            args[i] = argv[i].toString().intern();
        }
        int lastArg = argv.length - 1;
        int lastWindow = this.initPackingWindow(interp, argv, args, firstWindow);
        int firstArg = lastWindow + 1;
        int nArgs = lastArg - firstArg + 1;
        if (nArgs % 2 != 0) {
            throw new TclException(interp, "extra option \"" + argv[lastArg].toString() + "\" (option with no value?)");
        }
        Vector window1Special = new Vector();
        StringBuffer strippedArgs = new StringBuffer();
        this.getSpecialArgs(interp, args, lastWindow, window1Special, strippedArgs);
        PackerLayout.checkPackArgs(interp, strippedArgs.toString(), null);
        new Configure().exec(window1Special, args, strippedArgs.toString(), firstWindow, lastWindow);
    }

    String getParent(Interp interp, String widgetName) throws TclException {
        if (!Widgets.exists(interp, widgetName)) {
            throw new TclException(interp, "bad window path name \"" + widgetName + "\"");
        }
        String masterName = null;
        int lastDot = widgetName.lastIndexOf(".");
        if (lastDot == 0) {
            masterName = ".";
        } else {
            if (lastDot == -1) {
                throw new TclException(interp, "bad window path name \"" + widgetName + "\"");
            }
            masterName = widgetName.substring(0, lastDot);
        }
        return masterName;
    }

    class Configure
    extends GetValueOnEventThread {
        String specialWindowName = null;
        String parentName = null;
        Container parent = null;
        String option = null;
        String strippedArgs = null;
        Vector window1Special = null;
        int firstWindow = 0;
        int lastWindow = 0;
        SwkWidget[] swkWidgets = null;
        String[] args = null;
        String errMsg = null;

        Configure() {
        }

        void exec(Vector window1Special, String[] args, String strippedArgs, int firstWindow, int lastWindow) throws TclException {
            this.args = args;
            this.window1Special = window1Special;
            this.strippedArgs = strippedArgs;
            this.firstWindow = firstWindow;
            this.lastWindow = lastWindow;
            this.doSpecial();
            this.execOnThread();
            if (this.errMsg != null) {
                throw new TclException(PackCmd.this.interp, this.errMsg);
            }
        }

        void doSpecial() throws TclException {
            int j;
            if (this.window1Special.size() > 0) {
                for (j = 0; j < this.window1Special.size(); j += 2) {
                    this.option = (String)this.window1Special.elementAt(j);
                    this.specialWindowName = (String)this.window1Special.elementAt(j + 1);
                    if (this.option.equals("-after")) {
                        this.parentName = PackCmd.this.getParent(PackCmd.this.interp, this.specialWindowName);
                        this.parent = Widgets.getContainer(PackCmd.this.interp, this.parentName);
                        if (this.parent.getLayout() instanceof PackerLayout) continue;
                        throw new TclException(PackCmd.this.interp, "window \"" + this.specialWindowName + "\" isn't packed");
                    }
                    if (this.option.equals("-before")) {
                        this.parentName = PackCmd.this.getParent(PackCmd.this.interp, this.specialWindowName);
                        this.parent = Widgets.getContainer(PackCmd.this.interp, this.parentName);
                        if (this.parent.getLayout() instanceof PackerLayout) continue;
                        throw new TclException(PackCmd.this.interp, "window \"" + this.specialWindowName + "\" isn't packed");
                    }
                    if (!this.option.equals("-in")) continue;
                    this.parentName = (String)this.window1Special.elementAt(j + 1);
                    this.parent = Widgets.getContainer(PackCmd.this.interp, this.parentName);
                }
            }
            this.swkWidgets = new SwkWidget[this.lastWindow - this.firstWindow + 1];
            j = 0;
            for (int i = this.firstWindow; i <= this.lastWindow; ++i) {
                String windowName = this.args[i];
                if (this.window1Special.size() == 0) {
                    this.parentName = PackCmd.this.getParent(PackCmd.this.interp, windowName);
                    this.parent = Widgets.getContainer(PackCmd.this.interp, this.parentName);
                }
                int packPosition = -1;
                if (windowName.equals(this.parentName)) {
                    throw new TclException(PackCmd.this.interp, "can't pack \"" + windowName + "\" inside itself");
                }
                SwkWidget window = (SwkWidget)Widgets.get(PackCmd.this.interp, windowName);
                if (window instanceof JWindow || window instanceof JFrame) {
                    throw new TclException(PackCmd.this.interp, "can't pack \"" + windowName + "\": it's a top-level window");
                }
                this.swkWidgets[j++] = window;
            }
        }

        void doSpecial1() {
            int j = 0;
            block0: for (int i = this.firstWindow; i <= this.lastWindow; ++i) {
                String windowName = this.args[i];
                if (windowName.equals(this.specialWindowName)) continue;
                SwkWidget window = this.swkWidgets[j];
                int nMembers = this.parent.getComponentCount();
                for (int iWin = 0; iWin < nMembers; ++iWin) {
                    Component comp = this.parent.getComponent(iWin);
                    if (comp != (Component)((Object)window)) continue;
                    this.parent.remove((Component)((Object)window));
                    continue block0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addWindows() throws IllegalArgumentException {
            for (int i = 0; i < this.swkWidgets.length; ++i) {
                int packPosition = -1;
                String windowName = this.args[i];
                if (this.window1Special.size() > 0 && !this.option.equals("-in")) {
                    boolean isPacked = false;
                    int nMembers = this.parent.getComponentCount();
                    for (int iWin = 0; iWin < nMembers; ++iWin) {
                        Component comp = this.parent.getComponent(iWin);
                        if (!comp.getName().equals(this.specialWindowName)) continue;
                        packPosition = this.option.equals("-after") ? iWin + 1 : iWin;
                        isPacked = true;
                        if (!windowName.equals(this.specialWindowName)) break;
                        packPosition = iWin;
                        break;
                    }
                    if (!isPacked) {
                        throw new IllegalArgumentException("window \"" + this.specialWindowName + "\" isn't packed");
                    }
                }
                SwkWidget window = this.swkWidgets[i];
                LayoutManager layoutManager = this.parent.getLayout();
                PackerLayout packer = null;
                if (!(layoutManager instanceof PackerLayout)) {
                    this.parent.removeAll();
                    packer = new PackerLayout(PackCmd.this.interp);
                    this.parent.setLayout(packer);
                } else {
                    packer = (PackerLayout)layoutManager;
                }
                try {
                    packer.setIgnoreNextRemove(true);
                    this.parent.add((Component)((Object)window), this.strippedArgs, packPosition);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    packer.setIgnoreNextRemove(false);
                }
            }
            ((JComponent)this.parent).revalidate();
            LayoutHandler.addLayoutRequest(PackCmd.this.interp, this.parent);
        }

        public void run() {
            try {
                this.doSpecial1();
                this.addWindows();
                this.parent.repaint();
            }
            catch (IllegalArgumentException iaE) {
                this.errMsg = iaE.getMessage();
            }
        }
    }

    class Forget
    extends UpdateOnEventThread {
        String[] names = null;

        Forget() {
        }

        void exec(String[] names) {
            this.names = names;
            this.execOnThread();
        }

        public void run() {
            try {
                for (int i = 0; i < this.names.length; ++i) {
                    Container parent;
                    LayoutManager layoutManager;
                    String parentName;
                    if (!Widgets.exists(PackCmd.this.interp, this.names[i]) || (parentName = Widgets.parent(PackCmd.this.interp, this.names[i])).equals("") || !((layoutManager = (parent = Widgets.getContainer(PackCmd.this.interp, parentName)).getLayout()) instanceof PackerLayout)) continue;
                    SwkWidget window = (SwkWidget)Widgets.get(PackCmd.this.interp, this.names[i]);
                    parent.remove((Component)((Object)window));
                    Widgets.relayoutContainer(parent);
                    parent.repaint();
                }
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
    }

    class Slaves
    extends GetValueOnEventThread {
        String item = null;
        String[] names = null;

        Slaves() {
        }

        String[] exec(String item) {
            this.item = item;
            this.execOnThread();
            return this.names;
        }

        public void run() {
            Container parent = null;
            try {
                parent = Widgets.getContainer(PackCmd.this.interp, this.item);
            }
            catch (TclException tclE) {
                System.out.println("error slaves " + tclE.getMessage());
                PackCmd.this.interp.backgroundError();
                return;
            }
            int nMembers = parent.getComponentCount();
            this.names = new String[nMembers];
            for (int i = 0; i < nMembers; ++i) {
                Component comp = parent.getComponent(i);
                this.names[i] = comp.getName();
            }
        }
    }

    class Propagate
    extends GetValueOnEventThread {
        String item = null;
        boolean propagate = false;
        boolean setPropagate = false;

        Propagate() {
        }

        boolean exec(String item, boolean propagate, boolean setPropagate) {
            this.item = item;
            this.propagate = propagate;
            this.setPropagate = setPropagate;
            this.execOnThread();
            return this.propagate;
        }

        public void run() {
            Container parent = null;
            try {
                parent = Widgets.getContainer(PackCmd.this.interp, this.item);
            }
            catch (TclException tclE) {
                System.out.println("error prop " + tclE.getMessage());
                PackCmd.this.interp.backgroundError();
            }
            LayoutManager layoutManager = parent.getLayout();
            PackerLayout packer = null;
            if (!(layoutManager instanceof PackerLayout)) {
                parent.removeAll();
                packer = new PackerLayout(PackCmd.this.interp);
                parent.setLayout(packer);
            } else {
                packer = (PackerLayout)layoutManager;
            }
            if (this.setPropagate) {
                packer.propagate = this.propagate;
                Widgets.relayoutContainer(parent);
            }
            this.propagate = packer.propagate;
        }
    }

    class Info
    extends GetValueOnEventThread {
        String result = null;
        String item = null;
        SwkWidget window = null;

        Info() {
        }

        String exec(SwkWidget window, String item) {
            this.item = item;
            this.window = window;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            LayoutManager layoutManager;
            String parentName = null;
            Container parent = null;
            try {
                parentName = Widgets.parent(PackCmd.this.interp, this.item);
                parent = Widgets.getContainer(PackCmd.this.interp, parentName);
            }
            catch (TclException tclE) {
                parent = null;
            }
            if (parent != null && (layoutManager = parent.getLayout()) instanceof PackerLayout) {
                PackerLayout packer = (PackerLayout)layoutManager;
                String settings = packer.getComponentSettings((Component)((Object)this.window));
                this.result = "-in " + parentName + " " + settings.toString();
            }
        }
    }
}

