(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

open BaristaLibrary
open Common
open Instruction
open Utils

let () =
  let prefix = { Field.flags = [`Private; `Static; `Final];
		 Field.name = utf8_for_field "PREFIX";
                 Field.descriptor = class_String;
                 Field.attributes = [`ConstantValue (Attribute.String_value (utf8 "  - << "))] } in
  let suffix = { Field.flags = [`Private; `Static; `Final];
		 Field.name = utf8_for_field "SUFFIX";
		 Field.descriptor = class_String;
                 Field.attributes = [`ConstantValue (Attribute.String_value (utf8 " >>"))] } in
  let print_instructions param = [
    GETSTATIC ((utf8_for_class "java.lang.System"),
               (utf8_for_field "out"),
               class_PrintStream);
    DUP;
    DUP;
    GETSTATIC ((utf8_for_class "pack.Test"),
               (utf8_for_field "PREFIX"),
               class_String);
    INVOKEVIRTUAL ((`Class_or_interface (utf8_for_class "java.io.PrintStream")),
                   (utf8_for_method "print"),
                   ([(`Class (utf8_for_class "java.lang.String"))], `Void));
    (if param then ALOAD_0 else LDC (`String (utf8 "...")));
    INVOKEVIRTUAL ((`Class_or_interface (utf8_for_class "java.io.PrintStream")),
                   (utf8_for_method "print"),
                   ([(`Class (utf8_for_class "java.lang.String"))], `Void));
    GETSTATIC ((utf8_for_class "pack.Test"),
               (utf8_for_field "SUFFIX"),
               class_String);
    INVOKEVIRTUAL ((`Class_or_interface (utf8_for_class "java.io.PrintStream")),
                   (utf8_for_method "println"),
                   ([(`Class (utf8_for_class "java.lang.String"))], `Void));
    RETURN] in
  let instructions = [
    NOP;
    GETSTATIC ((utf8_for_class "java.lang.System"),
               (utf8_for_field "out"),
               class_PrintStream);
    LDC (`String (utf8 "hello\t... \n\t... \"world\""));
    INVOKEVIRTUAL ((`Class_or_interface (utf8_for_class "java.io.PrintStream")),
                               (utf8_for_method "println"),
                               ([(`Class (utf8_for_class "java.lang.String"))],
                                `Void));
    ICONST_0;
    ISTORE_1;
    ALOAD_0;
    ARRAYLENGTH;
    ISTORE_2;
    (* loop: *)
    ILOAD_1;
    ILOAD_2;
    IF_ICMPEQ (s2 15); (* end *)
    ALOAD_0;
    ILOAD_1;
    AALOAD;
    INVOKESTATIC ((utf8_for_class "pack.Test"),
                  (utf8_for_method "print"),
                  ([(`Class (utf8_for_class "java.lang.String"))], `Void));
    IINC (u1 1, s1 1);
    GOTO (s2 ~-14); (* loop *)
    (* end: *)
    (* test for method handles *)
    LDC (`Method_handle (`invokeStatic (utf8_for_class "pack.Test",
                                        utf8_for_method "print",
                                        ([], `Void))));
    INVOKEVIRTUAL (`Class_or_interface (utf8_for_class "java.lang.invoke.MethodHandle"),
                   (utf8_for_method "invokeExact"),
                   ([], `Void));
    LDC (`Method_handle (`invokeStatic (utf8_for_class "pack.Test",
                                        utf8_for_method "print",
                                        ([`Class (utf8_for_class "java.lang.String")], `Void))));
    LDC (`String (utf8 "zzz"));
    INVOKEVIRTUAL (`Class_or_interface (utf8_for_class "java.lang.invoke.MethodHandle"),
                   (utf8_for_method "invokeExact"),
                   ([`Class (utf8_for_class "java.lang.String")], `Void));
    (* test for invokedynamic *)
    NEW (utf8_for_class "pack.Test");
    DUP;
    INVOKESPECIAL ((utf8_for_class "pack.Test"),
                   (utf8_for_method "<init>"),
                   ([], `Void));
    INVOKEDYNAMIC ((`invokeStatic (utf8_for_class "pack.Test",
                                   utf8_for_method "bootstrap",
                                   ([`Class (utf8_for_class "java.lang.Object");
                                     `Class (utf8_for_class "java.lang.String");
                                     `Class (utf8_for_class "java.lang.invoke.MethodType");
                                     `Class (utf8_for_class "java.lang.String")], 
                                    (`Class (utf8_for_class "java.lang.invoke.CallSite")))),
                    [`String (utf8 "!PARAM-BOOT!")]),
                   utf8_for_method "xyz",
                   ([], `Void));
    RETURN ] in
  let init =
    compile_constructor
      [	ALOAD_0;
	INVOKESPECIAL (utf8_for_class "java.lang.Object",
                       utf8_for_method "<init>",
                       ([], `Void));
	RETURN ] in
  let print_no_arg_inst =
    compile_method
      ~name:"printInst"
      ~qualifiers:[`Public]
      ~signature:([], `Void)
      (print_instructions false) in
  let print_no_arg =
    compile_method
      ~name:"print"
      ~signature:([], `Void)
      (print_instructions false) in
  let print =
    compile_method
      ~name:"print"
      ~qualifiers:[`Public; `Static]
      ~signature:([class_String], `Void)
      (print_instructions true) in
  let bootstrap =
    compile_method
      ~name:"bootstrap"
      ~signature:([`Class (utf8_for_class "java.lang.Object");
                   `Class (utf8_for_class "java.lang.String");
                   `Class (utf8_for_class "java.lang.invoke.MethodType");
                   `Class (utf8_for_class "java.lang.String")],
                  `Class (utf8_for_class "java.lang.invoke.CallSite"))
      [ GETSTATIC (utf8_for_class "java.lang.System",
                   utf8_for_field "out",
                   `Class (utf8_for_class "java.io.PrintStream"));
        ALOAD_3;
        INVOKEVIRTUAL (`Class_or_interface (utf8_for_class "java.io.PrintStream"),
                       utf8_for_method "println",
                       ([`Class (utf8_for_class "java.lang.String")], `Void));
        NEW (utf8_for_class "java.lang.invoke.ConstantCallSite");
        DUP;
        LDC (`Method_handle (`invokeStatic (utf8_for_class "pack.Test",
                                            utf8_for_method "print",
                                            ([], `Void))));
        INVOKESPECIAL (utf8_for_class "java.lang.invoke.ConstantCallSite",
                       utf8_for_method "<init>",
                       ([`Class (utf8_for_class "java.lang.invoke.MethodHandle")], `Void));
        ARETURN ] in
  let main = compile_method instructions in
  let cls =
    compile_class
      ~qualifiers:[`Public; `Super; `Final; `Super]
      ~fields:[prefix; suffix]
      [init; print_no_arg_inst; print_no_arg; print; bootstrap; main] in
  write_class_file cls "pack/Test.class"
