(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Java- and UTF8-related constants used throughout the Barista project. *)


(** {6 Java constants} *)

val magic_number : int64


(** {6 String constants} *)

(** {7 Attribute-related strings} *)

val attr_annotation_default : UTF8.t

val attr_bootstrap_methods : UTF8.t

val attr_code : UTF8.t

val attr_constant_value : UTF8.t

val attr_deprecated : UTF8.t

val attr_enclosing_method : UTF8.t

val attr_exceptions : UTF8.t

val attr_inner_classes : UTF8.t

val attr_line_number_table : UTF8.t

val attr_local_variable_table : UTF8.t

val attr_local_variable_type_table : UTF8.t

val attr_method_parameters : UTF8.t

val attr_module : UTF8.t

val attr_module_requires : UTF8.t

val attr_module_permits : UTF8.t

val attr_module_provides : UTF8.t

val attr_runtime_invisible_annotations : UTF8.t

val attr_runtime_invisible_parameter_annotations : UTF8.t

val attr_runtime_invisible_type_annotations : UTF8.t

val attr_runtime_visible_annotations : UTF8.t

val attr_runtime_visible_parameter_annotations : UTF8.t

val attr_runtime_visible_type_annotations : UTF8.t

val attr_signature : UTF8.t

val attr_source_debug_extension : UTF8.t

val attr_source_file : UTF8.t

val attr_stack_map_table : UTF8.t

val attr_synthetic : UTF8.t

val attr_all : UTF8.t list

(** {7 Miscellaneous strings} *)

val class_constructor : UTF8.t

val class_initializer : UTF8.t

val empty_utf8 : UTF8.t

val java_lang_Object : UTF8.t


(** {6 Character constants} *)

(** {7 Capital letters} *)

val capital_b : UChar.t

val capital_c : UChar.t

val capital_d : UChar.t

val capital_f : UChar.t

val capital_i : UChar.t

val capital_j : UChar.t

val capital_l : UChar.t

val capital_s : UChar.t

val capital_t : UChar.t

val capital_v : UChar.t

val capital_z : UChar.t

(** {7 Small letters} *)

val small_c : UChar.t

val small_e : UChar.t

val small_s : UChar.t

(** {7 Digits} *)

val digits : UChar.t list

(** {7 Special characters} *)

val at_character : UChar.t

val back_slash : UChar.t

val circonflex : UChar.t

val closing_parenthesis : UChar.t

val closing_square_bracket : UChar.t

val colon : UChar.t

val comma : UChar.t

val dollar : UChar.t

val dot : UChar.t

val greater_than : UChar.t

val lower_than : UChar.t

val minus : UChar.t

val opening_parenthesis : UChar.t

val opening_square_bracket : UChar.t

val plus : UChar.t

val quote : UChar.t

val semi_colon : UChar.t

val sharp : UChar.t

val slash : UChar.t

val space : UChar.t

val star : UChar.t

val tabulation : UChar.t

val underscore : UChar.t

val percentage : UChar.t
