/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.threads;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.St_stubs;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="threads", module="Thread", source="otherlibs/threads/scheduler.c")
public final class Scheduler {
    private static final long TERMINATED = 2L;
    private static final Value RESUMED_IO = Value.THREE;
    private static final double MILLISECS_PER_SEC = 1000.0;

    private Scheduler() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_initialize(Value unit) {
        return St_stubs.caml_thread_initialize(unit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_initialize_preemption(Value unit) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"(unit -> unit)"}, returnType="Thread.t")
    public static Value thread_new(Value clos) {
        return St_stubs.caml_thread_new(clos);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="int")
    public static Value thread_id(Value th) {
        return St_stubs.caml_thread_id(th);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_yield(Value unit) throws FalseExit, FailException {
        return St_stubs.caml_thread_yield(unit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_request_reschedule(Value unit) throws FalseExit, FailException {
        return Scheduler.thread_yield(unit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_sleep(Value unit) throws FalseExit, FailException {
        Context ctxt = CurrentContext.get();
        Thread current = Thread.currentThread();
        if (current instanceof OCamlJavaThread) {
            CurrentContext.enterBlockingSection();
            ((OCamlJavaThread)current).pause();
            CurrentContext.leaveBlockingSection();
        } else assert (false) : "current thread should be an OCamlJavaThread";
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_desct"}, returnType="unit")
    public static Value thread_wait_read(Value fd) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value thread_wait_write(Value fd) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr * float"}, returnType="Thread.resumption_status")
    public static Value thread_wait_timed_read(Value fd) {
        return RESUMED_IO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr * float"}, returnType="Thread.resumption_status")
    public static Value thread_wait_timed_write(Value fd) {
        return RESUMED_IO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr list * Unix.file_descr list * Unix.file_descr list * float"}, returnType="Thread.resumption_status")
    public static Value thread_select(Value fd) throws FalseExit, FailException {
        return Scheduler.thread_yield(fd);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Always returns `true`."}, parameterTypes={"Pervasives.in_channel"}, returnType="bool")
    public static Value thread_inchan_ready(Value vchan) {
        return Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Always returns `true`."}, parameterTypes={"Pervasives.out_channel", "int"}, returnType="bool")
    public static Value thread_outchan_ready(Value vchan, Value vsize) {
        return Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="unit")
    public static Value thread_delay(Value time) throws FalseExit, FailException {
        Context ctxt = CurrentContext.get();
        CurrentContext.enterBlockingSection();
        try {
            Thread.sleep((long)(time.asDouble() * 1000.0));
        }
        catch (InterruptedException ie) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        CurrentContext.leaveBlockingSection();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value thread_join(Value th) throws FalseExit, FailException {
        return St_stubs.caml_thread_join(th);
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Does nothing, returning immediately."}, parameterTypes={"int"}, returnType="Thread.resumption_status")
    public static Value thread_wait_pid(Value pid) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value thread_wakeup(Value th) throws FailException {
        ThreadStatus ts = (ThreadStatus)th.get(2L).asCustom();
        if (!ts.isAlive()) {
            Fail.failWith("Thread.wakeup: killed thread");
        } else if (!ts.isSuspended()) {
            Fail.failWith("Thread.wakeup: thread not suspended");
        } else {
            ts.resume();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Thread.t")
    public static Value thread_self(Value unit) throws FailException {
        return St_stubs.caml_thread_self(unit);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value thread_kill(Value th) {
        ((ThreadStatus)th.get(2L).asCustom()).terminate();
        CurrentContext.enterBlockingSection();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"exn"}, returnType="unit")
    public static Value thread_uncaught_exception(Value exn) throws FalseExit, FailException {
        return St_stubs.caml_thread_uncaught_exception(exn);
    }
}

