/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMTransaction;
import org.ocamljava.runtime.values.Value;

final class STMVariable
implements Comparable<STMVariable> {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final int identifier = NEXT_ID.getAndIncrement();
    private final Semaphore writeLock = new Semaphore(1);
    private Value value;
    private int versionNumber;

    STMVariable(Value v, int vn) {
        this.value = v;
        this.versionNumber = vn;
    }

    Semaphore getWriteLock() {
        return this.writeLock;
    }

    Value get() {
        return this.value;
    }

    void set(Value v, int vn) {
        this.value = v;
        this.versionNumber = vn;
    }

    int getVersionNumber() {
        return this.versionNumber;
    }

    public int hashCode() {
        return this.identifier;
    }

    public boolean equals(Object obj) {
        if (obj instanceof STMTransaction) {
            STMVariable that = (STMVariable)obj;
            return that.identifier == this.identifier;
        }
        return false;
    }

    @Override
    public int compareTo(STMVariable that) {
        return Integer.compare(this.identifier, that.identifier);
    }
}

