/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;
import org.ocamljava.runtime.values.Value;

final class FutureCallable
implements Callable<Value>,
Runnable {
    private final Value closure;
    private final Value value;

    FutureCallable(Value c, Value v) {
        this.closure = c;
        this.value = v;
    }

    @Override
    public Value call() throws Exception {
        try {
            Value res = NativeApply.apply(this.closure, this.value);
            ThreadLocalFactory.remove();
            return res;
        }
        catch (Throwable t) {
            ThreadLocalFactory.remove();
            throw new ExecutionException(t);
        }
    }

    @Override
    public void run() {
        try {
            NativeApply.apply(this.closure, this.value);
            ThreadLocalFactory.remove();
        }
        catch (Throwable t) {
            ThreadLocalFactory.remove();
        }
    }
}

