/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Instructions;
import org.ocamljava.runtime.util.IntegerUtils;

public final class Disassembler {
    private Disassembler() {
    }

    private static int disassemble(Context ctxt, int pc, PrintWriter out) {
        assert (ctxt != null) : "null ctxt";
        assert (pc >= 0) : "pc should be >= 0";
        assert (out != null) : "null out";
        int[] code = ctxt.getCodeState().getCode();
        Dispatcher disp = ctxt.getCodeState().getDispatcher();
        int instr = code[pc];
        String mnemo = instr >= 0 && instr <= 143 ? Instructions.MNEMONICS[instr] : "???" + instr;
        out.printf("%06d  %s", pc, mnemo);
        switch (instr) {
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 103: 
            case 108: 
            case 127: 
            case 128: {
                out.printf(" %d", code[pc + 1]);
                return 2;
            }
            case 36: 
            case 43: 
            case 44: 
            case 55: 
            case 56: 
            case 62: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 139: 
            case 140: 
            case 141: {
                out.printf(" %d, %d", code[pc + 1], code[pc + 2]);
                return 3 + (instr == 44 ? code[pc + 1] : 0);
            }
            case 87: {
                long sizes = IntegerUtils.signedToUnsigned(code[pc + 1]);
                int szTag = (int)(sizes >> 16);
                int szInt = (int)(sizes & 0xFFFFL);
                out.printf(" sz%x=%d::ntag%d nint%d", sizes, sizes, szTag, szInt);
                return 2 + szTag + szInt;
            }
            case 98: {
                out.printf(" %d, %s", code[pc + 1], Disassembler.getPrimitiveName(disp, code[pc + 2]));
                return 3;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                out.printf(" %s", Disassembler.getPrimitiveName(disp, code[pc + 1]));
                return 2;
            }
        }
        return 1;
    }

    static void disassembleInstr(Context ctxt, int pc) {
        Disassembler.disassemble(ctxt, pc, new PrintWriter(System.out));
    }

    public static void disassembleAll(Context ctxt, PrintStream out) {
        assert (ctxt != null) : "null ctxt";
        assert (out != null) : "null out";
        int len = ctxt.getCodeState().getCode().length;
        PrintWriter writer = new PrintWriter(out);
        for (int pc = 0; pc < len; pc += Disassembler.disassemble(ctxt, pc, writer)) {
            writer.println();
        }
        writer.flush();
    }

    static String disassembleInstrString(Context ctxt, int pc) {
        assert (ctxt != null) : "null ctxt";
        StringWriter out = new StringWriter();
        Disassembler.disassemble(ctxt, pc, new PrintWriter(out));
        return out.toString();
    }

    private static String getPrimitiveName(Dispatcher disp, int id) {
        assert (disp != null) : "null disp";
        if (id >= 0 && id < disp.size()) {
            return disp.getName(id);
        }
        return "unknown primitive " + id;
    }
}

