/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.io.File;
import java.util.concurrent.Semaphore;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.parameters.CommonParameters;

public final class ContextWithRuntimeLock
extends Context {
    private Semaphore runtimeLock = new Semaphore(1, true);

    public ContextWithRuntimeLock(CommonParameters p, boolean isNative, File dir) {
        super(p, isNative, dir);
    }

    @Override
    public void enterBlockingSection() {
        this.runtimeLock.release();
    }

    @Override
    public void leaveBlockingSection() throws FalseExit, FailException {
        try {
            this.runtimeLock.acquire(1);
        }
        catch (InterruptedException ie) {
            FalseExit fe = FalseExit.createFromContext(this);
            fe.fillInStackTrace();
            throw fe;
        }
    }

    @Override
    public boolean tryLeaveBlockingSection() {
        return this.runtimeLock.tryAcquire(1);
    }

    @Override
    public boolean isRuntimeBusy() {
        return this.runtimeLock.availablePermits() > 0;
    }
}

