/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlNumber;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlInt32
extends OCamlValue
implements OCamlNumber {
    public static final Wrapper<OCamlInt32> WRAPPER = new SimpleWrapper<OCamlInt32>(){

        @Override
        public OCamlInt32 wrap(Value v) {
            return new OCamlInt32(v);
        }
    };

    private OCamlInt32(Value v) {
        super(v);
    }

    public Wrapper<? extends OCamlInt32> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        return OCamlUnit.WRAPPER;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value.asInt32();
    }

    @Override
    public double doubleValue() {
        return this.value.asInt32();
    }

    @Override
    public float floatValue() {
        return this.value.asInt32();
    }

    @Override
    public int intValue() {
        return this.value.asInt32();
    }

    @Override
    public long longValue() {
        return this.value.asInt32();
    }

    @Override
    public short shortValue() {
        return (short)this.value.asInt32();
    }

    @Override
    public int hashCode() {
        return this.value.asInt32();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlInt32) {
            OCamlInt32 that = (OCamlInt32)obj;
            return this.value.asInt32() == that.value.asInt32();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlInt32(");
        sb.append(this.value.asInt32());
        sb.append(")");
        return sb.toString();
    }

    public static OCamlInt32 create(int v) {
        return new OCamlInt32(Value.createInt32(v));
    }

    public static OCamlInt32 wrap(Value v) {
        assert (v != null) : "null v";
        return new OCamlInt32(v);
    }

    public static Wrapper<? extends OCamlInt32> wrapper() {
        return WRAPPER;
    }
}

