/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlException;
import org.ocamljava.runtime.wrappers.OCamlFunctionCaller;
import org.ocamljava.runtime.wrappers.OCamlFunctionImpl;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public abstract class OCamlFunction<T0 extends OCamlValue, TR extends OCamlValue>
extends OCamlValue {
    protected final Wrapper<T0> wrapper0;
    protected final Wrapper<TR> wrapperr;
    private static final MethodHandle METHOD_HANDLE;

    public OCamlFunction(Wrapper<T0> w0, Wrapper<TR> wr) {
        super(Value.UNIT);
        assert (w0 != null) : "null w0";
        assert (wr != null) : "null wr";
        this.wrapper0 = w0;
        this.wrapperr = wr;
    }

    public OCamlFunction() {
        this(OCamlValue.WRAPPER, OCamlValue.WRAPPER);
    }

    OCamlFunction(Value v, Wrapper<T0> w0, Wrapper<TR> wr) {
        super(v);
        assert (w0 != null) : "null w0";
        assert (wr != null) : "null wr";
        this.wrapper0 = w0;
        this.wrapperr = wr;
    }

    public final Wrapper<? extends OCamlFunction<T0, TR>> getWrapper() {
        return OCamlFunction.wrapper(this.wrapper0, this.wrapperr);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        switch (idx) {
            case 0: {
                return this.wrapper0;
            }
            case 1: {
                return this.wrapperr;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public Value getClosure(Wrapper<T0> w0) {
        assert (w0 != null) : "null w0";
        OCamlFunctionCaller ofc = new OCamlFunctionCaller(w0, this);
        return Value.createClosure(METHOD_HANDLE.bindTo(ofc));
    }

    public abstract TR execute(T0 var1) throws OCamlException;

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj instanceof OCamlFunction) {
            OCamlFunction that = (OCamlFunction)obj;
            return this == that;
        }
        return false;
    }

    @Override
    public final String toString() {
        return "OCamlFunction(...)";
    }

    public static <T0 extends OCamlValue, TR extends OCamlValue> OCamlFunction<T0, TR> wrap(Wrapper<T0> w0, Wrapper<TR> wr, Value v) {
        assert (w0 != null) : "null w0";
        assert (wr != null) : "null wr";
        assert (v != null) : "null v";
        return new OCamlFunctionImpl<T0, TR>(w0, wr, v);
    }

    public static <T0 extends OCamlValue, TR extends OCamlValue> Wrapper<? extends OCamlFunction<T0, TR>> wrapper(final Wrapper<T0> w0, final Wrapper<TR> wr) {
        assert (w0 != null) : "null w0";
        assert (wr != null) : "null wr";
        return new ComposedWrapper<OCamlFunction<T0, TR>>(new Wrapper[]{w0, wr}){

            @Override
            public OCamlFunction<T0, TR> wrap(Value v) {
                return new OCamlFunctionImpl(w0, wr, v);
            }
        };
    }

    static {
        MethodHandle mh;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType mt = MethodType.methodType(Value.class, Value.class);
            mh = lookup.findVirtual(OCamlFunctionCaller.class, "called", mt);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            assert (false) : "OCamlFunction: unable to get method handle";
            mh = null;
        }
        METHOD_HANDLE = mh;
    }
}

