/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/text.c")
public final class Text {
    private Text() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Argument is interpreted as a Java font name."}, parameterTypes={"string"}, returnType="unit")
    public static Value caml_gr_set_font(Value fnt) throws FailException {
        GraphSlot slot = GraphSlot.checkGraph();
        Font f = slot.getFont();
        slot.setFont(new Font(fnt.asString(), 0, f.getSize()));
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value caml_gr_set_text_size(Value sz) throws FailException {
        GraphSlot slot = GraphSlot.checkGraph();
        Font f = slot.getFont();
        slot.setFont(f.deriveFont((float)sz.asCastedInt()));
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"char"}, returnType="unit")
    public static Value caml_gr_draw_char(Value ch) throws FailException {
        Value s = Value.createString(1L);
        s.setUnsignedByte(0L, ch.asCastedInt());
        return Text.caml_gr_draw_string(s);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_gr_draw_string(Value str) throws FailException {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        int x = slot.getX();
        int y = slot.convertY(slot.getY());
        String s = str.asString();
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.drawString(s, x, y);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.drawString(s, x, y);
            store.dispose();
        }
        Graphics2D g = slot.getBuffer().createGraphics();
        FontMetrics fm = g.getFontMetrics(slot.getFont());
        Rectangle2D r = fm.getStringBounds(s, g);
        g.dispose();
        slot.setX(x + (int)r.getWidth());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int * int")
    public static Value caml_gr_text_size(Value str) throws FailException {
        GraphSlot slot = GraphSlot.checkGraph();
        Graphics2D g = slot.getBuffer().createGraphics();
        FontMetrics fm = g.getFontMetrics(slot.getFont());
        Rectangle2D r = fm.getStringBounds(str.asString(), g);
        g.dispose();
        return Value.createBlock(0, Value.createLong((int)r.getWidth()), Value.createLong((int)r.getHeight()));
    }
}

