/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.RecursiveTask;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.values.Value;

final class ForkJoinSplitArrayTask
extends RecursiveTask<Value> {
    static final long serialVersionUID = 0L;
    private final Value fork;
    private final Value join;
    private final Value closure;
    private final Value value;

    ForkJoinSplitArrayTask(Value f, Value j, Value c, Value x) {
        this.fork = f;
        this.join = j;
        this.closure = c;
        this.value = x;
    }

    @Override
    protected Value compute() {
        try {
            Value forkResult = NativeApply.apply(this.fork, this.value);
            int len = (int)forkResult.sizeValues();
            if (len == 0) {
                Value res = NativeApply.apply(this.closure, this.value);
                return res;
            }
            ForkJoinSplitArrayTask[] subs = new ForkJoinSplitArrayTask[len];
            for (int i = 0; i < len; ++i) {
                ForkJoinSplitArrayTask s;
                subs[i] = s = new ForkJoinSplitArrayTask(this.fork, this.join, this.closure, forkResult.get(i));
                s.fork();
            }
            Value acc = (Value)subs[0].join();
            for (int i = 1; i < len; ++i) {
                acc = NativeApply.apply(this.join, acc, (Value)subs[i].join());
            }
            return acc;
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
            return null;
        }
    }
}

