#
#  Copyright (c) 2005 Advanced Micro Devices, Inc.
#
#  See the file "license.amd" for information on usage and
#  redistribution of this file, and for a DISCLAIMER OF ALL
#   WARRANTIES.
#
#  RCS: @(#) $Id: parseproc.tcl,v 1.2 2006/02/10 02:20:12 mdejong Exp $
#
#

# The parseproc module will parse proc definitions out
# of a Tcl file. Each proc body will be replaced by
# a command to load the compiled version of the proc.

# depends on descend module

TJC::command parseproc_init tjc.ParseprocInitCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Given an input Tcl script that contains proc definitions,
# parse the proc definitions and return a list of them
# along with the modified script. The return value is
# a pair containing {outscript proclist}. The outscript
# return value is a modified version of inscript that
# has proc body declarations replaced by a command
# to load a compiled version of the proc. The proclist
# is a list of proc body definitions that were parsed
# from the inscript.

TJC::command parseproc_start tjc.ParseprocStartCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked each time a command is parsed by the descend module.
# If a command name can't be statically resolved then this
# procedure just ignores it. The command is also ignored
# if command arguments could not be determined.

TJC::command parseproc_command_callback tjc.ParseprocCommandCallbackCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked each time a command and its contents are finished
# being parsed by the descend module.

TJC::command parseproc_command_finish_callback tjc.ParseprocCommandFinishCallbackCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Process a proc command invocation discovered while parsing script

TJC::command parseproc_command_proc tjc.ParseprocCommandProcCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Append data to the outscript starting from the end of last
# processed command and leading up to (but not including)
# the passed in range. This function assumes the original
# script and ranges into the original script.

TJC::command _parseproc_append_outscript_up_to tjc.ParseprocAppendOutscriptUpToCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# Append data to the outscript starting from the end of last
# processed command and leading up to and including passed
# in range. This function accepts a script argument that
# is used to pass in a rewritten script.

TJC::command _parseproc_append_outscript_including tjc.ParseprocAppendOutscriptIncludingCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#



# Return 1 if the proc args contained in argstr adhere to
# Tcl's rules. If they don't, then we will not know how
# to compile the proc args.

TJC::command parseproc_args_ok tjc.ParseprocArgsOkCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


