/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/gethost.c")
public final class Gethost {
    private Gethost() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Array of aliases is always empty."}, parameterTypes={"Unix.inet_addr"}, returnType="Unix.host_entry")
    public static Value unix_gethostbyaddr(Value value) throws FailException {
        try {
            return Gethost.createHost(new InetAddress[]{InetAddress.getByAddress(value.getBytes())});
        }
        catch (UnknownHostException unknownHostException) {
            Fail.raiseNotFound();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Array of aliases is always empty."}, parameterTypes={"string"}, returnType="Unix.host_entry")
    public static Value unix_gethostbyname(Value value) throws FailException {
        try {
            return Gethost.createHost(InetAddress.getAllByName(value.asString()));
        }
        catch (UnknownHostException unknownHostException) {
            Fail.raiseNotFound();
            return Value.UNIT;
        }
    }

    private static Value createHost(InetAddress[] inetAddressArray) {
        int n = inetAddressArray.length;
        Value value = Value.createBlock(0, n);
        for (int i = 0; i < n; ++i) {
            value.set(i, Value.createString(inetAddressArray[i].getAddress()));
        }
        return Value.createBlock(0, Value.createString(inetAddressArray[0].getHostName()), CurrentContext.CODE_STATE.getAtom(0), inetAddressArray[0].getAddress().length == 4 ? Value.ONE : Value.TWO, value);
    }
}

