/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.StringValue;
import org.ocamljava.runtime.values.Value;

public final class CachedStringValue
extends BlockValue {
    private static final int MAX_CACHED_SIZE = 1024;
    private long size;
    private byte[] bytes;
    private String cache;

    CachedStringValue(String string) {
        int n = string.length();
        this.bytes = null;
        this.size = n;
        this.cache = string;
    }

    @Override
    public synchronized String asString() {
        if (this.cache == null) {
            String string = EncodingUtils.convertBytesToString(this.bytes);
            if (this.bytes.length <= 1024) {
                this.cache = string;
            }
            return string;
        }
        return this.cache;
    }

    @Override
    public byte[] getBytes() {
        this.useBytes();
        return this.bytes;
    }

    @Override
    public synchronized byte[] getBytesForModification() {
        this.useBytes();
        this.cache = null;
        return this.bytes;
    }

    @Override
    public int[] getUnsignedBytes() {
        this.useBytes();
        int n = this.bytes.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.bytes[i] & 0xFF;
        }
        return nArray;
    }

    @Override
    public byte getByte(long l) throws ArrayIndexOutOfBoundsException {
        if (l == this.size) {
            return 0;
        }
        if (this.bytes != null) {
            return this.bytes[(int)l];
        }
        char c = this.cache.charAt((int)l);
        return (byte)(c < '\u0100' ? (int)c : 63);
    }

    @Override
    public synchronized void setByte(long l, byte by) throws ArrayIndexOutOfBoundsException {
        this.useBytes();
        this.bytes[(int)l] = by;
        this.cache = null;
    }

    @Override
    public int getUnsignedByte(long l) throws ArrayIndexOutOfBoundsException {
        if (l == this.size) {
            return 0;
        }
        if (this.bytes != null) {
            return this.bytes[(int)l] & 0xFF;
        }
        char c = this.cache.charAt((int)l);
        int n = c < '\u0100' ? (int)c : 63;
        return n & 0xFF;
    }

    @Override
    public synchronized void setUnsignedByte(long l, int n) throws ArrayIndexOutOfBoundsException {
        this.useBytes();
        this.setByte(l, (byte)(n & 0xFF));
        this.cache = null;
    }

    @Override
    public long sizeBytes() {
        return this.size;
    }

    @Override
    protected void truncateInstance(long l) {
        this.useBytes();
        this.bytes = Arrays.copyOf(this.bytes, (int)(l * 8L));
        this.size = l;
    }

    @Override
    public synchronized void copy(BlockValue blockValue) {
        this.useBytes();
        int n = (int)Math.min((long)this.bytes.length, blockValue.sizeBytes());
        for (int i = 0; i < n; ++i) {
            this.bytes[i] = blockValue.getByte(i);
        }
        this.cache = null;
    }

    @Override
    public Value duplicate() {
        if (this.bytes == null) {
            return new CachedStringValue(this.cache);
        }
        return new StringValue(Arrays.copyOf(this.bytes, this.bytes.length));
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray) {
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray, int n) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dArray, int n) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] lArray, int n) {
    }

    @Override
    public Value subArray(long l, long l2) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long l, Value value, long l2, long l3) {
    }

    public int hashCode() {
        this.useBytes();
        int n = 0;
        int n2 = Math.min(32, this.bytes.length);
        for (int i = 0; i < n2; ++i) {
            n += 31 * this.bytes[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        this.useBytes();
        if (object instanceof CachedStringValue) {
            CachedStringValue cachedStringValue = (CachedStringValue)object;
            cachedStringValue.useBytes();
            return Arrays.equals(this.bytes, cachedStringValue.bytes);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CachedStringValue(");
        stringBuilder.append(this.asString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private synchronized void useBytes() {
        if (this.bytes == null) {
            this.bytes = new byte[this.cache.length()];
            EncodingUtils.convertStringToBytes(this.cache, this.bytes, 0);
        }
    }

    @Override
    public void set(Value value, long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(Value, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setParent(BlockValue blockValue) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object object) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int n) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long l) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long l) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws FatalError {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long l) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(l));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public long getRawLong(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(long) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong(int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(int) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong0() {
        assert (false) : "getRawLong0() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong1() {
        assert (false) : "getRawLong1() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong2() {
        assert (false) : "getRawLong2() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong3() {
        assert (false) : "getRawLong3() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong4() {
        assert (false) : "getRawLong4() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong5() {
        assert (false) : "getRawLong5() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong6() {
        assert (false) : "getRawLong6() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong7() {
        assert (false) : "getRawLong7() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setRawLong(long l, long l2) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(long, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong(int n, long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(int, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong0(long l) {
        assert (false) : "setRawLong0(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong1(long l) {
        assert (false) : "setRawLong1(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong2(long l) {
        assert (false) : "setRawLong2(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong3(long l) {
        assert (false) : "setRawLong3(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong4(long l) {
        assert (false) : "setRawLong4(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong5(long l) {
        assert (false) : "setRawLong5(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong6(long l) {
        assert (false) : "setRawLong6(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong7(long l) {
        assert (false) : "setRawLong7(long) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeLongs() {
        assert (false) : "sizeLongs() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getDouble(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble(int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble0() {
        assert (false) : "getDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble1() {
        assert (false) : "getDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble2() {
        assert (false) : "getDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble3() {
        assert (false) : "getDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble4() {
        assert (false) : "getDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble5() {
        assert (false) : "getDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble6() {
        assert (false) : "getDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble7() {
        assert (false) : "getDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble0(double d) {
        assert (false) : "setDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble1(double d) {
        assert (false) : "setDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble2(double d) {
        assert (false) : "setDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble3(double d) {
        assert (false) : "setDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble4(double d) {
        assert (false) : "setDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble5(double d) {
        assert (false) : "setDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble6(double d) {
        assert (false) : "setDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble7(double d) {
        assert (false) : "setDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeDoubles() {
        assert (false) : "sizeDoubles() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getGenericDouble(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble(int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble0() {
        assert (false) : "getGenericDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble1() {
        assert (false) : "getGenericDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble2() {
        assert (false) : "getGenericDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble3() {
        assert (false) : "getGenericDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble4() {
        assert (false) : "getGenericDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble5() {
        assert (false) : "getGenericDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble6() {
        assert (false) : "getGenericDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble7() {
        assert (false) : "getGenericDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setGenericDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble0(double d) {
        assert (false) : "setGenericDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble1(double d) {
        assert (false) : "setGenericDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble2(double d) {
        assert (false) : "setGenericDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble3(double d) {
        assert (false) : "setGenericDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble4(double d) {
        assert (false) : "setGenericDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble5(double d) {
        assert (false) : "setGenericDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble6(double d) {
        assert (false) : "setGenericDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble7(double d) {
        assert (false) : "setGenericDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value get(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get(int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(int) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get0() {
        assert (false) : "get0() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get1() {
        assert (false) : "get1() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get2() {
        assert (false) : "get2() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get3() {
        assert (false) : "get3() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get4() {
        assert (false) : "get4() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get5() {
        assert (false) : "get5() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get6() {
        assert (false) : "get6() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get7() {
        assert (false) : "get7() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void set(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set(int n, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(int, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set0(Value value) {
        assert (false) : "set0(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set1(Value value) {
        assert (false) : "set1(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set2(Value value) {
        assert (false) : "set2(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set3(Value value) {
        assert (false) : "set3(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set4(Value value) {
        assert (false) : "set4(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set5(Value value) {
        assert (false) : "set5(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set6(Value value) {
        assert (false) : "set6(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set7(Value value) {
        assert (false) : "set7(Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeValues() {
        assert (false) : "sizeValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLength() {
        assert (false) : "arrayLength() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value getWeak(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public final long getWoSize() {
        return (this.size + 8L) / 8L;
    }

    @Override
    public final long getHeader() {
        return BlockValue.makeHeader(252, (this.size + 8L) / 8L);
    }

    @Override
    public void setHeader(long l) {
    }

    @Override
    public final int getTag() {
        return 252;
    }

    @Override
    public final void setTag(int n) {
    }
}

