/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Exchanger", source="")
public final class Exchanger {
    private Exchanger() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="Exchanger.t")
    public static Value ocamljava_exchanger_make(Value value) throws FailException {
        return Value.createInstance(new java.util.concurrent.Exchanger());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Exchanger.t", "'a"}, returnType="'a")
    public static Value ocamljava_exchanger_exchange(Value value, Value value2) throws FailException {
        java.util.concurrent.Exchanger exchanger = (java.util.concurrent.Exchanger)value.asCustom();
        try {
            return exchanger.exchange(value2);
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Exchanger.exchange");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Exchanger.t", "'a", "int64", "TimeUnit.t"}, returnType="'a")
    public static Value ocamljava_exchanger_exchange_time(Value value, Value value2, Value value3, Value value4) throws FailException {
        java.util.concurrent.Exchanger exchanger = (java.util.concurrent.Exchanger)value.asCustom();
        try {
            return exchanger.exchange(value2, value3.asInt64(), TimeUnit.decode(value4));
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Exchanger.exchange_time");
            return Value.UNIT;
        }
        catch (TimeoutException timeoutException) {
            Runtime.raiseTimeout("Concurrent.Exchanger.exchange_time");
            return Value.UNIT;
        }
    }
}

