/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Date;
import tcl.lang.ExprValue;
import tcl.lang.Interp;
import tcl.lang.NoArgMathFunction;
import tcl.lang.TclException;

class RandFunction
extends NoArgMathFunction {
    private static final int randIA = 16807;
    private static final int randIM = Integer.MAX_VALUE;
    private static final int randIQ = 127773;
    private static final int randIR = 2836;
    private static final Date date = new Date();

    RandFunction() {
    }

    void apply(Interp interp, ExprValue value) throws TclException {
        RandFunction.statApply(interp, value);
    }

    static void statApply(Interp interp, ExprValue value) throws TclException {
        if (!interp.randSeedInit) {
            interp.randSeedInit = true;
            interp.randSeed = (int)date.getTime();
        }
        if (interp.randSeed == 0L) {
            interp.randSeed = 123459876L;
        }
        int tmp = (int)(interp.randSeed / 127773L);
        interp.randSeed = 16807L * (interp.randSeed - (long)(tmp * 127773)) - (long)(2836 * tmp);
        if (interp.randSeed < 0L) {
            interp.randSeed += Integer.MAX_VALUE;
        }
        value.setDoubleValue((double)interp.randSeed * 4.656612875245797E-10);
    }
}

