/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.values.Value;

public final class NativeComparisons {
    private NativeComparisons() {
    }

    public static boolean equalValues(Value value, Value value2) {
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        if (value.isBlock()) {
            return value2.isBlock() ? value == value2 : false;
        }
        return value.getRawValue() == value2.getRawValue();
    }

    public static boolean notEqualValues(Value value, Value value2) {
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        return !NativeComparisons.equalValues(value, value2);
    }

    public static boolean lowerThanValue(Value value, Value value2) {
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        return Value.compare(value, value2) < 0;
    }

    public static boolean lowerEqualValue(Value value, Value value2) {
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        return Value.compare(value, value2) <= 0;
    }

    public static boolean greaterThanValue(Value value, Value value2) {
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        return Value.compare(value, value2) > 0;
    }

    public static boolean greaterEqualValue(Value value, Value value2) {
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        return Value.compare(value, value2) >= 0;
    }

    public static boolean isOut(long l, long l2) {
        if (l2 >= 0L) {
            return l >= 0L && l < l2;
        }
        return l >= 0L || l < l2;
    }

    public static boolean isOutFirstPositive(long l, long l2) {
        assert (l >= 0L) : "invalid v1";
        return l2 < 0L || l < l2;
    }

    public static boolean isOutSecondPositive(long l, long l2) {
        assert (l2 >= 0L) : "invalid v2";
        return l >= 0L && l < l2;
    }

    public static boolean isOutValue(Value value, Value value2) {
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        return Value.compareUnsigned(value, value2) < 0;
    }
}

