/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.values.Value;

public final class Fail {
    private Fail() {
    }

    public static void raise(Value value) throws FailException {
        assert (value != null) : "null v";
        throw new FailException(value);
    }

    public static void raiseWithConstant(Value value) throws FailException {
        assert (value != null) : "null tag";
        throw new FailException(Value.createBlock(0, value));
    }

    public static FailException createWithConstant(Value value) {
        assert (value != null) : "null tag";
        return new FailException(Value.createBlock(0, value));
    }

    public static void raiseWithArg(Value value, Value value2) throws FailException {
        assert (value != null) : "null tag";
        assert (value2 != null) : "null arg";
        throw new FailException(Value.createBlock(0, value, value2));
    }

    public static FailException createWithArg(Value value, Value value2) {
        assert (value != null) : "null tag";
        assert (value2 != null) : "null arg";
        return new FailException(Value.createBlock(0, value, value2));
    }

    public static void raiseWithArgs(Value value, Value ... valueArray) throws FailException {
        assert (value != null) : "null tag";
        assert (valueArray != null) : "null args";
        int n = valueArray.length;
        Value value2 = Value.createBlock(0, 1 + n);
        value2.set0(value);
        for (int i = 0; i < n; ++i) {
            value2.set(1 + i, valueArray[i]);
        }
        throw new FailException(value2);
    }

    public static void raiseWithString(Value value, String string) throws FailException {
        assert (value != null) : "null tag";
        assert (string != null) : "null msg";
        throw new FailException(Value.createBlock(0, value, Value.createString(string)));
    }

    public static FailException createWithString(Value value, String string) {
        assert (value != null) : "null tag";
        assert (string != null) : "null msg";
        return new FailException(Value.createBlock(0, value, Value.createString(string)));
    }

    public static void failWith(String string) throws FailException {
        assert (string != null) : "null msg";
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnFailure;
        throw new FailException(Value.createBlock(0, value, Value.createString(string)));
    }

    public static void invalidArgument(String string) throws FailException {
        assert (string != null) : "null msg";
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnInvalidArgument;
        throw new FailException(Value.createBlock(0, value, Value.createString(string)));
    }

    public static void raiseSysError(String string) throws FailException {
        assert (string != null) : "null msg";
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnSysError;
        throw new FailException(Value.createBlock(0, value, Value.createString(string)));
    }

    public static void arrayBoundError() throws FailException {
        Fail.invalidArgument("index out of bounds");
    }

    public static void raiseOutOfMemory() throws FailException {
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnOutOfMemory;
        throw new FailException(Value.createBlock(0, value));
    }

    public static void raiseStackOverflow() throws FailException {
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnStackOverflow;
        throw new FailException(Value.createBlock(0, value));
    }

    public static void raiseEndOfFile() throws FailException {
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnEndOfFile;
        throw new FailException(Value.createBlock(0, value));
    }

    public static void raiseZeroDivide() throws FailException {
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnDivisionByZero;
        throw new FailException(Value.createBlock(0, value));
    }

    public static void raiseNotFound() throws FailException {
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnNotFound;
        throw new FailException(Value.createBlock(0, value));
    }

    public static void raiseSysBlockedIO() throws FailException {
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnSysBlockedIO;
        throw new FailException(Value.createBlock(0, value));
    }

    static FailException createZeroDivide() {
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnDivisionByZero;
        return new FailException(Value.createBlock(0, value));
    }

    static FailException createStackOverflow() {
        Value value = CurrentContext.PREDEFINED_EXCEPTIONS.exnStackOverflow;
        return new FailException(Value.createBlock(0, value));
    }

    public static Value asValue(Throwable throwable) throws FalseExit {
        if (throwable instanceof FailException) {
            return ((FailException)throwable).getValue();
        }
        if (throwable instanceof FatalError) {
            throw (FatalError)throwable;
        }
        if (throwable instanceof FalseExit) {
            throw (FalseExit)throwable;
        }
        Value value = throwable instanceof Exception ? CurrentContext.PREDEFINED_EXCEPTIONS.exnJavaException : CurrentContext.PREDEFINED_EXCEPTIONS.exnJavaError;
        return Value.createBlock(0, value, Value.createInstance(throwable));
    }

    public static void reraise(Throwable throwable, Value value) throws FailException {
        if (throwable instanceof Throwable) {
            throw (FailException)throwable;
        }
        throw new FailException(value);
    }
}

