/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.PlacerLayout;
import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import com.onemoonscientific.swank.canvas.AnchorParameter;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.HeightParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import com.onemoonscientific.swank.canvas.WindowParameter;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class ItemWindow
extends SwkShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new WindowParameter(), new AnchorParameter(), new WidthParameter(), new HeightParameter(), new TagsParameter(), new TransformerParameter()};
    static Map parameterMap = new TreeMap();
    ImageIcon image;
    String windowName = "";
    int width = 0;
    int height = 0;
    PlacerLayout placer = null;
    SwkWidget window = null;

    ItemWindow(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.storeCoords = new double[2];
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 2) {
            throw new SwkException("wrong # coordinates: expected 2, got " + coords.length);
        }
        this.storeCoords[0] = coords[0];
        this.storeCoords[1] = coords[1];
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public void configShape(Interp interp, SwkImageCanvas swkCanvas, TclObject[] argv, int start) throws TclException {
        for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length || !"-window".startsWith(argv[i].toString())) continue;
            this.windowName = argv[i + 1].toString();
            this.setupLayout(interp);
            break;
        }
        super.configShape(interp, swkCanvas, argv, start);
    }

    public void applyCoordinates() {
        this.addWindow();
    }

    void setupLayout(Interp interp) throws TclException {
        if (this.windowName == null || this.windowName.equals("")) {
            return;
        }
        this.window = (SwkWidget)Widgets.get(interp, this.windowName);
        if (!(this.canvas.getComponent() instanceof Container)) {
            throw new TclException(interp, "can't add window to this type of canvas");
        }
        Container parent = (Container)this.canvas.getComponent();
        LayoutManager layoutManager = parent.getLayout();
        if (!(layoutManager instanceof PlacerLayout)) {
            parent.removeAll();
            this.placer = new PlacerLayout(interp);
            parent.setLayout(this.placer);
        } else {
            this.placer = (PlacerLayout)layoutManager;
        }
    }

    void addWindow() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("-x ");
        sbuf.append((int)this.storeCoords[0]);
        sbuf.append(" -y ");
        sbuf.append((int)this.storeCoords[1]);
        if (this.width != 0) {
            sbuf.append(" -width ");
            sbuf.append(this.width);
        }
        if (this.height != 0) {
            sbuf.append(" -height ");
            sbuf.append(this.height);
        }
        Container parent = (Container)this.canvas.getComponent();
        this.placeWindow(parent, this.placer, this.window, sbuf.toString());
        Component comp = (Component)((Object)this.window);
        this.shape = comp.getBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void placeWindow(Container parent, PlacerLayout placer, SwkWidget window, String layoutString) {
        try {
            ((Component)((Object)window)).invalidate();
            if (!placer.updateLayoutComponent(layoutString, (Component)((Object)window))) {
                placer.setIgnoreNextRemove(true);
                parent.add(layoutString, (Component)((Object)window));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            placer.setIgnoreNextRemove(false);
        }
    }

    public String getType() {
        return "window";
    }

    static {
        ItemWindow.initializeParameters(parameters, parameterMap);
    }
}

